/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.keycloak.example.ldap;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.keycloak.KeycloakSecurityContext;
import org.keycloak.common.util.Base64;
import org.keycloak.representations.IDToken;

/**
 * Tests binary LDAP attribute
 *
 * @author <a href="mailto:mposolda@redhat.com">Marek Posolda</a>
 */
public class LDAPPictureServlet extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("image/jpeg");
        ServletOutputStream outputStream = resp.getOutputStream();

        KeycloakSecurityContext securityContext = (KeycloakSecurityContext) req.getAttribute(KeycloakSecurityContext.class.getName());
        IDToken idToken = securityContext.getIdToken();

        // TODO: Use idToken.getPicture() instead
        Object profilePicture = idToken.getOtherClaims().get("profile_picture");

        if (profilePicture != null) {
            String base64EncodedPicture = getBase64EncodedPicture(profilePicture);
            byte[] decodedPicture = Base64.decode(base64EncodedPicture);
            outputStream.write(decodedPicture);
        }

        outputStream.flush();
    }

    private String getBase64EncodedPicture(Object profilePicture) {
        if (profilePicture instanceof List) {
            return ((List) profilePicture).get(0).toString();
        } else {
            return profilePicture.toString();
        }
    }
}
