package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Revision: 1 $
 */
public interface ClientModel extends RoleContainerModel {

    // COMMON ATTRIBUTES

    String PRIVATE_KEY = "privateKey";
    String PUBLIC_KEY = "publicKey";
    String X509CERTIFICATE = "X509Certificate";

    void updateClient();

    String getId();

    String getClientId();

    void setClientId(String clientId);

    String getName();

    void setName(String name);

    boolean isEnabled();

    void setEnabled(boolean enabled);

    boolean isSurrogateAuthRequired();

    void setSurrogateAuthRequired(boolean surrogateAuthRequired);

    Set<String> getWebOrigins();

    void setWebOrigins(Set<String> webOrigins);

    void addWebOrigin(String webOrigin);

    void removeWebOrigin(String webOrigin);

    Set<String> getRedirectUris();

    void setRedirectUris(Set<String> redirectUris);

    void addRedirectUri(String redirectUri);

    void removeRedirectUri(String redirectUri);

    String getManagementUrl();

    void setManagementUrl(String url);

    String getBaseUrl();

    void setBaseUrl(String url);

    List<String> getDefaultRoles();

    void addDefaultRole(String name);

    void updateDefaultRoles(String[] defaultRoles);

    Set<RoleModel> getClientScopeMappings(ClientModel client);

    boolean isBearerOnly();
    void setBearerOnly(boolean only);

    int getNodeReRegistrationTimeout();

    void setNodeReRegistrationTimeout(int timeout);

    boolean validateSecret(String secret);
    String getSecret();
    public void setSecret(String secret);

    boolean isFullScopeAllowed();
    void setFullScopeAllowed(boolean value);

    String getProtocol();
    void setProtocol(String protocol);

    void setAttribute(String name, String value);
    void removeAttribute(String name);
    String getAttribute(String name);
    Map<String, String> getAttributes();

    boolean isFrontchannelLogout();
    void setFrontchannelLogout(boolean flag);


    boolean isPublicClient();
    void setPublicClient(boolean flag);

    boolean isDirectGrantsOnly();
    void setDirectGrantsOnly(boolean flag);

    boolean isConsentRequired();
    void setConsentRequired(boolean consentRequired);

    Set<RoleModel> getScopeMappings();
    void addScopeMapping(RoleModel role);
    void deleteScopeMapping(RoleModel role);
    Set<RoleModel> getRealmScopeMappings();
    boolean hasScope(RoleModel role);

    RealmModel getRealm();

    /**
     * Time in seconds since epoc
     *
     * @return
     */
    int getNotBefore();

    void setNotBefore(int notBefore);

    Set<ProtocolMapperModel> getProtocolMappers();
    ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model);
    void removeProtocolMapper(ProtocolMapperModel mapping);
    void updateProtocolMapper(ProtocolMapperModel mapping);
    public ProtocolMapperModel getProtocolMapperById(String id);
    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name);

    Map<String, Integer> getRegisteredNodes();

    /**
     * Register node or just update the 'lastReRegistration' time if this node is already registered
     *
     * @param nodeHost
     * @param registrationTime
     */
    void registerNode(String nodeHost, int registrationTime);

    void unregisterNode(String nodeHost);
}
