/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.module;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.handlers.module.ModuleConfigImpl;
import org.jboss.as.cli.handlers.module.ModuleDependency;
import org.jboss.as.cli.handlers.module.ResourceRoot;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.ExpressionBaseState;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ASModuleHandler
extends CommandHandlerWithHelp {
    private static final String JBOSS_HOME = "JBOSS_HOME";
    private static final String PATH_SEPARATOR = File.pathSeparator;
    private static final String MODULE_SEPARATOR = ",";
    private static final String ACTION_ADD = "add";
    private static final String ACTION_REMOVE = "remove";
    private final ArgumentWithValue action = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public Collection<String> getAllCandidates(CommandContext ctx) {
            return Arrays.asList(ASModuleHandler.ACTION_ADD, ASModuleHandler.ACTION_REMOVE);
        }
    }), 0, "--action");
    private final ArgumentWithValue name;
    private final ArgumentWithValue mainClass;
    private final ArgumentWithValue resources;
    private final ArgumentWithValue dependencies;
    private final ArgumentWithValue props;
    private final ArgumentWithValue moduleArg;
    private final ArgumentWithValue slot;
    private final ArgumentWithValue resourceDelimiter;
    private File modulesDir;

    public ASModuleHandler(CommandContext ctx) {
        super("module", false);
        final FilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        final CommandLineCompleter moduleNameCompleter = new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                String modulesPath;
                String path = buffer.replace('.', File.separatorChar);
                try {
                    modulesPath = ASModuleHandler.this.getModulesDir().getAbsolutePath() + File.separatorChar;
                }
                catch (CommandLineException e) {
                    return -1;
                }
                int result = pathCompleter.complete(ctx, modulesPath + path, cursor, candidates);
                if (result < 0) {
                    return result;
                }
                for (int i = 0; i < candidates.size(); ++i) {
                    candidates.set(i, candidates.get(i).replace(File.separatorChar, '.'));
                }
                return result - modulesPath.length();
            }
        };
        this.name = new ArgumentWithValue(this, moduleNameCompleter, "--name"){

            @Override
            protected ParsingState initParsingState() {
                ExpressionBaseState state = new ExpressionBaseState("EXPR", true, false);
                if (Util.isWindows()) {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_OFF);
                } else {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
                }
                return state;
            }
        };
        this.name.addRequiredPreceding(this.action);
        this.mainClass = new AddModuleArgument("--main-class");
        this.resources = new AddModuleArgument("--resources", new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int lastSeparator = buffer.lastIndexOf(PATH_SEPARATOR);
                if (lastSeparator >= 0) {
                    return lastSeparator + 1 + pathCompleter.complete(ctx, buffer.substring(lastSeparator + 1), cursor, candidates);
                }
                return pathCompleter.complete(ctx, buffer, cursor, candidates);
            }
        }){

            @Override
            public String getValue(ParsedCommandLine args) {
                String value = super.getValue(args);
                if (value != null) {
                    if (value.length() >= 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    value = pathCompleter.translatePath(value);
                }
                return value;
            }

            @Override
            protected ParsingState initParsingState() {
                ExpressionBaseState state = new ExpressionBaseState("EXPR", true, false);
                if (Util.isWindows()) {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_OFF);
                } else {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
                }
                return state;
            }
        };
        this.resourceDelimiter = new AddModuleArgument("--resource-delimiter");
        this.dependencies = new AddModuleArgument("--dependencies", new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int lastSeparator = buffer.lastIndexOf(ASModuleHandler.MODULE_SEPARATOR);
                if (lastSeparator >= 0) {
                    return lastSeparator + 1 + moduleNameCompleter.complete(ctx, buffer.substring(lastSeparator + 1), cursor, candidates);
                }
                return moduleNameCompleter.complete(ctx, buffer, cursor, candidates);
            }
        });
        this.props = new AddModuleArgument("--properties");
        this.moduleArg = new FileSystemPathArgument(this, pathCompleter, "--module-xml"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                String actionValue = ASModuleHandler.this.action.getValue(ctx.getParsedCommandLine());
                return ASModuleHandler.ACTION_ADD.equals(actionValue) && ASModuleHandler.this.name.isPresent(ctx.getParsedCommandLine()) && super.canAppearNext(ctx);
            }
        };
        this.slot = new ArgumentWithValue((CommandHandlerWithArguments)this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                File moduleDir;
                String moduleName = ASModuleHandler.this.name.getValue(ctx.getParsedCommandLine());
                if (moduleName == null) {
                    return Collections.emptyList();
                }
                try {
                    moduleDir = new File(ASModuleHandler.this.getModulesDir(), moduleName.replace('.', File.separatorChar));
                }
                catch (CommandLineException e) {
                    return Collections.emptyList();
                }
                if (!moduleDir.exists()) {
                    return Collections.emptyList();
                }
                return Arrays.asList(moduleDir.list());
            }
        }), "--slot");
        this.moduleArg.addCantAppearAfter(this.mainClass);
        this.moduleArg.addCantAppearAfter(this.dependencies);
        this.moduleArg.addCantAppearAfter(this.props);
        this.mainClass.addCantAppearAfter(this.moduleArg);
        this.dependencies.addCantAppearAfter(this.moduleArg);
        this.props.addCantAppearAfter(this.moduleArg);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return !ctx.isDomainMode();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        String actionValue = this.action.getValue(parsedCmd);
        if (actionValue == null) {
            throw new CommandFormatException("Action argument is missing: add or remove");
        }
        if (ACTION_ADD.equals(actionValue)) {
            this.addModule(ctx, parsedCmd);
        } else if (ACTION_REMOVE.equals(actionValue)) {
            this.removeModule(parsedCmd);
        } else {
            throw new CommandFormatException("Unexpected action '" + actionValue + "', expected values: " + ACTION_ADD + ", " + ACTION_REMOVE);
        }
    }

    protected void addModule(CommandContext ctx, ParsedCommandLine parsedCmd) throws CommandLineException {
        ModuleConfigImpl config;
        String moduleName = this.name.getValue(parsedCmd, true);
        String resourcePaths = this.resources.getValue(parsedCmd, !this.moduleArg.isPresent(parsedCmd));
        String pathDelimiter = PATH_SEPARATOR;
        if (this.resourceDelimiter.isPresent(parsedCmd)) {
            pathDelimiter = this.resourceDelimiter.getValue(parsedCmd);
        }
        FilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        String[] resourceArr = resourcePaths == null ? new String[]{} : resourcePaths.split(pathDelimiter);
        File[] resourceFiles = new File[resourceArr.length];
        for (int i = 0; i < resourceArr.length; ++i) {
            File f = new File(pathCompleter.translatePath(resourceArr[i]));
            if (!f.exists()) {
                throw new CommandLineException("Failed to locate " + f.getAbsolutePath());
            }
            resourceFiles[i] = f;
        }
        File moduleDir = this.getModulePath(this.getModulesDir(), moduleName, this.slot.getValue(parsedCmd));
        if (moduleDir.exists()) {
            throw new CommandLineException("Module " + moduleName + " already exists at " + moduleDir.getAbsolutePath());
        }
        if (!moduleDir.mkdirs()) {
            throw new CommandLineException("Failed to create directory " + moduleDir.getAbsolutePath());
        }
        String moduleXml = this.moduleArg.getValue(parsedCmd);
        if (moduleXml != null) {
            config = null;
            File[] source = new File(moduleXml);
            if (!source.exists()) {
                throw new CommandLineException("Failed to locate the file on the filesystem: " + source.getAbsolutePath());
            }
            ASModuleHandler.copy((File)source, new File(moduleDir, "module.xml"));
        } else {
            config = new ModuleConfigImpl(moduleName);
        }
        for (File f : resourceFiles) {
            ASModuleHandler.copy(f, new File(moduleDir, f.getName()));
            if (config == null) continue;
            config.addResource(new ResourceRoot(f.getName()));
        }
        if (config != null) {
            String mainCls;
            String slotVal;
            String propsStr;
            String dependenciesStr = this.dependencies.getValue(parsedCmd);
            if (dependenciesStr != null) {
                String[] depsArr;
                for (String dep : depsArr = dependenciesStr.split(",+")) {
                    config.addDependency(new ModuleDependency(dep));
                }
            }
            if ((propsStr = this.props.getValue(parsedCmd)) != null) {
                String[] pairs;
                for (String pair : pairs = propsStr.split(MODULE_SEPARATOR)) {
                    int equals = pair.indexOf(61);
                    if (equals == -1) {
                        throw new CommandFormatException("Property '" + pair + "' in '" + propsStr + "' is missing the equals sign.");
                    }
                    String propName = pair.substring(0, equals);
                    if (propName.isEmpty()) {
                        throw new CommandFormatException("Property name is missing for '" + pair + "' in '" + propsStr + "'");
                    }
                    config.setProperty(propName, pair.substring(equals + 1));
                }
            }
            if ((slotVal = this.slot.getValue(parsedCmd)) != null) {
                config.setSlot(slotVal);
            }
            if ((mainCls = this.mainClass.getValue(parsedCmd)) != null) {
                config.setMainClass(mainCls);
            }
            FileWriter moduleWriter = null;
            File moduleFile = new File(moduleDir, "module.xml");
            try {
                moduleWriter = new FileWriter(moduleFile);
                XMLExtendedStreamWriter xmlWriter = ASModuleHandler.create(XMLOutputFactory.newInstance().createXMLStreamWriter(moduleWriter));
                config.writeContent(xmlWriter, null);
                xmlWriter.flush();
            }
            catch (IOException e) {
                throw new CommandLineException("Failed to create file " + moduleFile.getAbsolutePath(), e);
            }
            catch (XMLStreamException e) {
                throw new CommandLineException("Failed to write to " + moduleFile.getAbsolutePath(), e);
            }
            finally {
                if (moduleWriter != null) {
                    try {
                        moduleWriter.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void removeModule(ParsedCommandLine parsedCmd) throws CommandLineException {
        String moduleName = this.name.getValue(parsedCmd, true);
        File modulesDir = this.getModulesDir();
        File modulePath = this.getModulePath(modulesDir, moduleName, this.slot.getValue(parsedCmd));
        if (!modulePath.exists()) {
            throw new CommandLineException("Failed to locate module " + moduleName + " at " + modulePath.getAbsolutePath());
        }
        this.deleteRecursively(modulePath);
        modulePath = modulePath.getParentFile();
        while (!modulesDir.equals(modulePath) && modulePath.list().length <= 0) {
            if (!modulePath.delete()) {
                throw new CommandLineException("Failed to delete " + modulePath.getAbsolutePath());
            }
            modulePath = modulePath.getParentFile();
        }
    }

    protected void deleteRecursively(File file) throws CommandLineException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                this.deleteRecursively(f);
            }
        }
        if (!file.delete()) {
            throw new CommandLineException("Failed to delete " + file.getAbsolutePath());
        }
    }

    protected File getModulePath(File modulesDir, String moduleName, String slot) throws CommandLineException {
        return new File(modulesDir, moduleName.replace('.', File.separatorChar) + File.separatorChar + (slot == null ? "main" : slot));
    }

    protected File getModulesDir() throws CommandLineException {
        if (this.modulesDir != null) {
            return this.modulesDir;
        }
        String modulesDirStr = WildFlySecurityManager.getEnvPropertyPrivileged((String)JBOSS_HOME, null);
        if (modulesDirStr == null) {
            throw new CommandLineException("JBOSS_HOME environment variable is not set.");
        }
        this.modulesDir = new File(modulesDirStr, "modules");
        if (!this.modulesDir.exists()) {
            throw new CommandLineException("Failed to locate the modules dir on the filesystem: " + this.modulesDir.getAbsolutePath());
        }
        return this.modulesDir;
    }

    public static XMLExtendedStreamWriter create(XMLStreamWriter writer) throws CommandLineException {
        try {
            Class<?> clazz = Class.forName("org.jboss.staxmapper.FormattingXMLStreamWriter");
            Constructor<?> ctr = clazz.getConstructor(XMLStreamWriter.class);
            ctr.setAccessible(true);
            return (XMLExtendedStreamWriter)ctr.newInstance(writer);
        }
        catch (Exception e) {
            throw new CommandLineException("Failed to create xml stream writer.", e);
        }
    }

    public static void copy(File source, File target) throws CommandLineException {
        byte[] buff = new byte[8192];
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(source));
            out = new BufferedOutputStream(new FileOutputStream(target));
            while ((read = in.read(buff)) != -1) {
                ((BufferedOutputStream)out).write(buff, 0, read);
            }
            ((BufferedOutputStream)out).flush();
        }
        catch (FileNotFoundException e) {
            throw new CommandLineException("Failed to locate the file on the filesystem copying " + source.getAbsolutePath() + " to " + target.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to copy " + source.getAbsolutePath() + " to " + target.getAbsolutePath(), e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private class AddModuleArgument
    extends ArgumentWithValue {
        private AddModuleArgument(String fullName) {
            super(ASModuleHandler.this, fullName);
        }

        private AddModuleArgument(String fullName, CommandLineCompleter completer) {
            super((CommandHandlerWithArguments)ASModuleHandler.this, completer, fullName);
        }

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            String actionValue = ASModuleHandler.this.action.getValue(ctx.getParsedCommandLine());
            return ASModuleHandler.ACTION_ADD.equals(actionValue) && ASModuleHandler.this.name.isPresent(ctx.getParsedCommandLine()) && super.canAppearNext(ctx);
        }
    }
}

