/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import org.jboss.as.cli.CliConfig;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.ControllerAddress;

public class ControllerAddressResolver {
    private final CliConfig config;
    private final String defaultController;

    private ControllerAddressResolver(CliConfig config, String defaultController) {
        this.config = config;
        this.defaultController = defaultController;
    }

    public static ControllerAddressResolver newInstance(CliConfig config, String defaultController) {
        return new ControllerAddressResolver(config, defaultController);
    }

    public ControllerAddress resolveAddress(String controller) throws CommandLineException {
        ControllerAddress intermediate = controller != null ? this.convert(controller) : (this.defaultController != null ? this.convert(this.defaultController) : this.config.getDefaultControllerAddress());
        return this.finish(intermediate);
    }

    private ControllerAddress finish(ControllerAddress toFinish) throws CommandLineException {
        String protocol = toFinish.getProtocol();
        String host = toFinish.getHost();
        int port = toFinish.getPort();
        if (protocol == null) {
            protocol = this.config.isUseLegacyOverride() && port == 9999 ? "remoting" : this.config.getDefaultControllerProtocol();
        }
        if (host == null) {
            throw new CommandLineException("null host encountered");
        }
        if (port < 0) {
            if ("remote".equals(protocol) || "remoting".equals(protocol)) {
                port = 9999;
            } else if ("http-remoting".equals(protocol)) {
                port = 9990;
            } else if ("https-remoting".equals(protocol)) {
                port = 9993;
            } else {
                throw new CommandLineException("Unexpected protocol '" + protocol + "'");
            }
        }
        return new ControllerAddress(protocol, host, port);
    }

    private ControllerAddress convert(String controller) throws CommandLineException {
        String parsing;
        ControllerAddress alias = this.config.getAliasedControllerAddress(controller);
        if (alias != null) {
            return alias;
        }
        String protocol = null;
        String host = null;
        int port = -1;
        int protocolEnd = controller.lastIndexOf("://");
        if (protocolEnd == -1) {
            parsing = controller;
        } else {
            parsing = controller.substring(protocolEnd + 3);
            protocol = controller.substring(0, protocolEnd);
        }
        String portStr = null;
        int colonIndex = parsing.lastIndexOf(58);
        if (colonIndex < 0) {
            host = parsing;
        } else if (colonIndex == 0) {
            portStr = parsing.substring(1).trim();
        } else {
            int closeBracket = parsing.lastIndexOf(93);
            boolean hasPort = closeBracket != -1 ? closeBracket <= colonIndex : true;
            if (hasPort) {
                host = parsing.substring(0, colonIndex).trim();
                portStr = parsing.substring(colonIndex + 1).trim();
            } else {
                host = parsing;
            }
        }
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                throw new CommandFormatException("The port must be a valid non-negative integer: '" + parsing + "'");
            }
            if (port < 0) {
                throw new CommandFormatException("The port must be a valid non-negative integer: '" + parsing + "'");
            }
        }
        return new ControllerAddress(protocol, host, port);
    }
}

