/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.metacommand;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.component.BrowseButton;
import org.jboss.as.cli.gui.component.HelpButton;
import org.jboss.as.cli.gui.component.ServerGroupChooser;

public class DeployCommandDialog
extends JDialog
implements ActionListener {
    private static JFileChooser fileChooser = new JFileChooser(new File("."));
    private CliGuiContext cliGuiCtx;
    private JPanel inputPanel = new JPanel(new GridBagLayout());
    private JTextField pathField = new JTextField(40);
    private JTextField nameField = new JTextField(40);
    private JTextField runtimeNameField = new JTextField(40);
    private JCheckBox forceCheckBox = new JCheckBox("force");
    private JCheckBox disabledCheckBox = new JCheckBox("disabled");
    private ServerGroupChooser serverGroupChooser;
    private JCheckBox allServerGroups = new JCheckBox("all-server-groups");

    public DeployCommandDialog(CliGuiContext cliGuiCtx) {
        super(cliGuiCtx.getMainWindow(), "deploy", Dialog.ModalityType.APPLICATION_MODAL);
        this.cliGuiCtx = cliGuiCtx;
        this.serverGroupChooser = new ServerGroupChooser(cliGuiCtx);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(10, 10));
        this.setAllServerGroupsListener();
        this.setForceListener();
        contentPane.add((Component)this.makeInputPanel(), "Center");
        contentPane.add((Component)this.makeButtonPanel(), "South");
        this.pack();
        this.setResizable(false);
    }

    private void setAllServerGroupsListener() {
        this.allServerGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeployCommandDialog.this.allServerGroups.isSelected()) {
                    DeployCommandDialog.this.serverGroupChooser.setEnabled(false);
                } else {
                    DeployCommandDialog.this.serverGroupChooser.setEnabled(true);
                }
            }
        });
    }

    private void setForceListener() {
        this.forceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeployCommandDialog.this.forceCheckBox.isSelected()) {
                    DeployCommandDialog.this.serverGroupChooser.setEnabled(false);
                    DeployCommandDialog.this.allServerGroups.setEnabled(false);
                    DeployCommandDialog.this.allServerGroups.setSelected(false);
                    DeployCommandDialog.this.disabledCheckBox.setEnabled(false);
                    DeployCommandDialog.this.disabledCheckBox.setSelected(false);
                } else {
                    DeployCommandDialog.this.serverGroupChooser.setEnabled(true);
                    DeployCommandDialog.this.allServerGroups.setEnabled(true);
                    DeployCommandDialog.this.disabledCheckBox.setEnabled(true);
                }
            }
        });
    }

    private JPanel makeInputPanel() {
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.anchor = 17;
        gbConst.insets = new Insets(5, 5, 5, 5);
        JLabel pathLabel = new JLabel("File Path:");
        gbConst.gridwidth = 1;
        this.inputPanel.add((Component)pathLabel, gbConst);
        this.addStrut();
        this.inputPanel.add((Component)this.pathField, gbConst);
        this.addStrut();
        BrowseButton browse = new BrowseButton(this, this.pathField);
        gbConst.gridwidth = 0;
        this.inputPanel.add((Component)browse, gbConst);
        JLabel nameLabel = new JLabel("Name:");
        gbConst.gridwidth = 1;
        this.inputPanel.add((Component)nameLabel, gbConst);
        this.addStrut();
        gbConst.gridwidth = 0;
        this.inputPanel.add((Component)this.nameField, gbConst);
        JLabel runtimeNameLabel = new JLabel("Runtime Name:");
        gbConst.gridwidth = 1;
        this.inputPanel.add((Component)runtimeNameLabel, gbConst);
        this.addStrut();
        gbConst.gridwidth = 0;
        this.inputPanel.add((Component)this.runtimeNameField, gbConst);
        JLabel forceLabel = new JLabel();
        gbConst.gridwidth = 1;
        this.inputPanel.add((Component)forceLabel, gbConst);
        gbConst.gridwidth = 0;
        this.inputPanel.add((Component)this.forceCheckBox, gbConst);
        JLabel disabledLabel = new JLabel();
        gbConst.gridwidth = 1;
        this.inputPanel.add((Component)disabledLabel, gbConst);
        gbConst.gridwidth = 0;
        this.inputPanel.add((Component)this.disabledCheckBox, gbConst);
        if (this.cliGuiCtx.isStandalone()) {
            return this.inputPanel;
        }
        JLabel serverGroupLabel = new JLabel();
        gbConst.gridwidth = 1;
        this.inputPanel.add((Component)serverGroupLabel, gbConst);
        gbConst.gridwidth = 0;
        this.inputPanel.add((Component)this.serverGroupChooser, gbConst);
        gbConst.gridwidth = 1;
        this.inputPanel.add((Component)new JLabel(), gbConst);
        gbConst.gridwidth = 0;
        this.inputPanel.add((Component)this.allServerGroups, gbConst);
        return this.inputPanel;
    }

    private void addStrut() {
        this.inputPanel.add(Box.createHorizontalStrut(5));
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        ok.setMnemonic(10);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DeployCommandDialog.this.dispose();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        buttonPanel.add(new HelpButton("deploy.txt"));
        return buttonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String runtimeName;
        StringBuilder builder = new StringBuilder("deploy");
        String path = this.pathField.getText();
        if (path.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "A file must be selected.", "Empty File Path", 0);
            return;
        }
        builder.append("  ").append(path);
        String name = this.nameField.getText();
        if (!name.trim().isEmpty()) {
            builder.append("  --name=").append(name);
        }
        if (!(runtimeName = this.runtimeNameField.getText()).trim().isEmpty()) {
            builder.append("  --runtime-name=").append(runtimeName);
        }
        if (this.forceCheckBox.isSelected()) {
            builder.append("  --force");
        }
        if (this.disabledCheckBox.isSelected() && this.disabledCheckBox.isEnabled()) {
            builder.append("  --disabled");
        }
        if (!this.cliGuiCtx.isStandalone()) {
            if (this.allServerGroups.isSelected() && this.allServerGroups.isEnabled()) {
                builder.append("  --all-server-groups");
            } else if (this.serverGroupChooser.isEnabled()) {
                builder.append(this.serverGroupChooser.getCmdLineArg());
            }
        }
        JTextComponent cmdText = this.cliGuiCtx.getCommandLine().getCmdText();
        cmdText.setText(builder.toString());
        this.dispose();
        cmdText.requestFocus();
    }
}

