/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.io.IOException;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.component.ServerLogsTable;
import org.jboss.dmr.ModelNode;

public class ServerLogsTableModel
extends AbstractTableModel {
    private CliGuiContext cliGuiCtx;
    private List<ModelNode> allLogs;
    private ServerLogsTable table;
    protected String[] colNames = new String[]{"File", "Last Modified", "Size"};

    public ServerLogsTableModel(CliGuiContext cliGuiCtx, ServerLogsTable table) {
        this.cliGuiCtx = cliGuiCtx;
        this.table = table;
    }

    public void refresh() {
        try {
            this.allLogs = this.cliGuiCtx.getExecutor().doCommand("/subsystem=logging/:list-log-files").get("result").asList();
            this.fireTableDataChanged();
            this.table.getRowSorter().toggleSortOrder(1);
            this.table.getRowSorter().toggleSortOrder(1);
            if (this.allLogs.size() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        }
        catch (IOException | CommandFormatException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getRowCount() {
        if (this.allLogs == null) {
            return 0;
        }
        return this.allLogs.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModelNode row = this.allLogs.get(rowIndex);
        if (columnIndex == 0) {
            return row.get("file-name").asString();
        }
        if (columnIndex == 1) {
            String dateTime = row.get("last-modified-date").asString();
            dateTime = dateTime.substring(0, dateTime.indexOf(46));
            String date = dateTime.substring(0, dateTime.indexOf(84));
            String time = dateTime.substring(date.length() + 1, dateTime.length());
            return date + " " + time;
        }
        return row.get("file-size").asLong();
    }

    @Override
    public String getColumnName(int column) {
        return this.colNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 2) {
            return Long.class;
        }
        return String.class;
    }
}

