/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.arguments;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ArgumentValueCallbackHandler
implements ParsingStateCallbackHandler {
    private static byte QUOTES = 1;
    private static byte ESCAPE = (byte)2;
    private Deque<ValueState> stack;
    private ValueState currentState;
    private byte flag;

    @Override
    public void enteredState(ParsingContext ctx) throws CommandFormatException {
        String stateId = ctx.getState().getId();
        if ("ARG_VALUE".equals(stateId)) {
            if (this.currentState != null) {
                if (this.currentState.isOnSeparator() && !this.currentState.isComposite()) {
                    this.currentState.enteredValue();
                }
                this.pushCurrentState();
                this.currentState = new DefaultValueState();
            } else {
                this.currentState = new DefaultValueState();
            }
        } else if ("OBJECT".equals(stateId)) {
            if (this.currentState != null) {
                this.currentState.enteredValue();
                this.pushCurrentState();
            }
            this.currentState = ctx.getCharacter() == '[' ? new ListValueState() : new ObjectValueState();
        } else if ("LIST".equals(stateId)) {
            if (this.currentState != null) {
                this.currentState.enteredValue();
                this.pushCurrentState();
            }
            this.currentState = new ListValueState();
        } else if ("LIST_ITEM_SEP".equals(stateId)) {
            this.currentState.itemSeparator();
        } else if ("NAME_VALUE_SEP".equals(stateId)) {
            this.currentState.nameSeparator(ctx);
        } else if ("QUOTES".equals(stateId)) {
            this.flag = (byte)(this.flag ^ QUOTES);
        } else if ("ESCAPED_CHARACTER".equals(stateId)) {
            this.flag = (byte)(this.flag ^ ESCAPE);
        }
    }

    void pushCurrentState() {
        if (this.stack == null) {
            this.stack = new ArrayDeque<ValueState>();
        }
        this.stack.push(this.currentState);
    }

    @Override
    public void leavingState(ParsingContext ctx) throws CommandFormatException {
        String stateId = ctx.getState().getId();
        if ("ARG_VALUE".equals(stateId) || "OBJECT".equals(stateId) || "LIST".equals(stateId)) {
            if (!this.currentState.isOnSeparator() && this.stack != null && this.stack.peek() != null) {
                this.stack.peek().addChild(this.currentState);
                this.currentState = this.stack.pop();
                if (!this.currentState.isComposite() && this.stack.peek() != null) {
                    this.stack.peek().addChild(this.currentState);
                    this.currentState = this.stack.pop();
                }
            }
        } else if ("QUOTES".equals(stateId)) {
            this.flag = (byte)(this.flag ^ QUOTES);
        } else if ("ESCAPED_CHARACTER".equals(stateId)) {
            this.flag = (byte)(this.flag ^ ESCAPE);
        }
    }

    @Override
    public void character(ParsingContext ctx) throws CommandFormatException {
        this.currentState.character(ctx.getCharacter());
    }

    public ModelNode getResult() {
        ModelNode result;
        if (this.currentState.getName() != null) {
            result = new ModelNode();
            result.get(this.currentState.getName()).set(this.currentState.getValue());
        } else {
            result = this.currentState.getValue();
        }
        return result;
    }

    class ObjectValueState
    implements ValueState {
        private ModelNode obj;
        private boolean onSeparator;
        private boolean primitiveList;

        ObjectValueState() {
        }

        @Override
        public boolean isOnSeparator() {
            return this.onSeparator;
        }

        @Override
        public void enteredValue() {
            this.onSeparator = false;
        }

        @Override
        public void addChild(ValueState child) {
            if (child.getName() == null) {
                if (this.obj != null) {
                    if (this.obj.getType() == ModelType.LIST) {
                        this.obj.add(child.getValue());
                    } else {
                        ModelNode tmp = this.obj;
                        this.obj = new ModelNode();
                        this.obj.add(tmp);
                        this.obj.add(child.getValue());
                        this.primitiveList = true;
                    }
                    return;
                }
                this.obj = child.getValue();
                return;
            }
            if (this.primitiveList) {
                throw new IllegalStateException("Can't add a property " + child.getName() + "=" + child.getValue() + " to a list of values " + this.obj.asString());
            }
            if (this.obj == null) {
                this.obj = new ModelNode();
            }
            this.obj.get(child.getName()).set(child.getValue());
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void nameSeparator(ParsingContext ctx) throws CommandFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void itemSeparator() throws CommandFormatException {
            this.onSeparator = true;
        }

        @Override
        public void character(char ch) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ModelNode getValue() {
            if (this.obj == null) {
                return new ModelNode();
            }
            return this.obj;
        }

        @Override
        public boolean isComposite() {
            return true;
        }
    }

    class ListValueState
    implements ValueState {
        private ModelNode list;
        private boolean onSeparator;

        ListValueState() {
        }

        @Override
        public boolean isOnSeparator() {
            return this.onSeparator;
        }

        @Override
        public void enteredValue() {
            this.onSeparator = false;
        }

        @Override
        public void addChild(ValueState child) {
            ModelNode ch;
            if (child.getName() != null) {
                ch = new ModelNode();
                ch.set(child.getName(), child.getValue());
            } else {
                ch = child.getValue();
            }
            if (this.list != null) {
                this.list.add(ch);
            } else {
                this.list = ch;
                if (this.list.getType() != ModelType.LIST) {
                    ModelNode list = new ModelNode();
                    list.add(this.list);
                    this.list = list;
                }
            }
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void nameSeparator(ParsingContext ctx) throws CommandFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void itemSeparator() throws CommandFormatException {
            this.onSeparator = true;
        }

        @Override
        public void character(char ch) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ModelNode getValue() {
            if (this.list == null) {
                ModelNode node = new ModelNode();
                node.setEmptyList();
                return node;
            }
            return this.list;
        }

        @Override
        public boolean isComposite() {
            return true;
        }
    }

    class DefaultValueState
    implements ValueState {
        protected String name;
        protected StringBuilder buf;
        protected int trimToSize = -1;
        protected boolean dontQuote;
        protected boolean onSeparator;
        protected ModelNode child;

        DefaultValueState() {
        }

        @Override
        public boolean isOnSeparator() {
            return this.onSeparator;
        }

        @Override
        public void enteredValue() {
            this.onSeparator = false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void nameSeparator(ParsingContext ctx) throws CommandFormatException {
            if (this.buf == null) {
                throw new CommandFormatException("Property name is null.");
            }
            if (this.name != null) {
                this.buf.append(ctx.getCharacter());
            } else {
                this.name = this.getTrimmedString();
                this.buf.setLength(0);
            }
            this.onSeparator = true;
        }

        @Override
        public void character(char ch) {
            if (this.name != null) {
                throw new IllegalStateException("the name is already complete");
            }
            if (this.buf == null) {
                this.buf = new StringBuilder();
            }
            if ((byte)(ArgumentValueCallbackHandler.this.flag & ESCAPE) > 0) {
                this.buf.append(ch);
            } else if ((byte)(ArgumentValueCallbackHandler.this.flag & QUOTES) > 0) {
                if (ch == '\"') {
                    if (this.buf.length() == 0) {
                        this.dontQuote = true;
                    } else if (!this.dontQuote) {
                        this.buf.append(ch);
                    }
                } else {
                    this.buf.append(ch);
                }
            } else if (!Character.isWhitespace(ch)) {
                this.buf.append(ch);
                if (this.trimToSize >= 0) {
                    this.trimToSize = -1;
                }
            } else if (this.buf.length() > 0) {
                if (this.trimToSize < 0) {
                    this.trimToSize = this.buf.length();
                }
                this.buf.append(ch);
            }
        }

        @Override
        public void itemSeparator() {
        }

        @Override
        public void addChild(ValueState child) {
            if (this.child != null) {
                throw new IllegalStateException("child is already initialized");
            }
            this.child = child.getValue();
        }

        @Override
        public ModelNode getValue() {
            if (this.child != null) {
                return this.child;
            }
            return this.getStringValue();
        }

        private ModelNode getStringValue() {
            ModelNode value = new ModelNode();
            if (this.buf != null) {
                value.set(this.getTrimmedString());
            }
            return value;
        }

        @Override
        public boolean isComposite() {
            return false;
        }

        protected String getTrimmedString() {
            if (this.trimToSize >= 0) {
                this.buf.setLength(this.trimToSize);
                this.trimToSize = -1;
            }
            return this.buf.toString();
        }
    }

    static interface ValueState {
        public void addChild(ValueState var1);

        public String getName();

        public void nameSeparator(ParsingContext var1) throws CommandFormatException;

        public void itemSeparator() throws CommandFormatException;

        public void character(char var1);

        public ModelNode getValue();

        public boolean isComposite();

        public boolean isOnSeparator();

        public void enteredValue();
    }
}

