###################################################################################
#                                                                                 #
#                   Copyright 2010-2013 Ning, Inc.                                #
#                                                                                 #
#      Ning licenses this file to you under the Apache License, version 2.0       #
#      (the "License"); you may not use this file except in compliance with the   #
#      License.  You may obtain a copy of the License at:                         #
#                                                                                 #
#          http://www.apache.org/licenses/LICENSE-2.0                             #
#                                                                                 #
#      Unless required by applicable law or agreed to in writing, software        #
#      distributed under the License is distributed on an "AS IS" BASIS, WITHOUT  #
#      WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the  #
#      License for the specific language governing permissions and limitations    #
#      under the License.                                                         #
#                                                                                 #
###################################################################################


#
#                       DO NOT EDIT!!!
#    File automatically generated by killbill-java-parser (git@github.com:killbill/killbill-java-parser.git)
#


module Killbill
  module Plugin
    module Model

      java_package 'org.killbill.billing.entitlement.api'
      class SubscriptionEvent

        include org.killbill.billing.entitlement.api.SubscriptionEvent

        attr_accessor :id, :entitlement_id, :effective_date, :requested_date, :subscription_event_type, :is_blocked_billing, :is_blocked_entitlement, :service_name, :service_state_name, :prev_product, :prev_plan, :prev_phase, :prev_price_list, :prev_billing_period, :next_product, :next_plan, :next_phase, :next_price_list, :next_billing_period

        def initialize()
        end

        def to_java()
          # conversion for id [type = java.util.UUID]
          @id = java.util.UUID.fromString(@id.to_s) unless @id.nil?

          # conversion for entitlement_id [type = java.util.UUID]
          @entitlement_id = java.util.UUID.fromString(@entitlement_id.to_s) unless @entitlement_id.nil?

          # conversion for effective_date [type = org.joda.time.LocalDate]
          if !@effective_date.nil?
            @effective_date = Java::org.joda.time.LocalDate.parse(@effective_date.to_s)
          end

          # conversion for requested_date [type = org.joda.time.LocalDate]
          if !@requested_date.nil?
            @requested_date = Java::org.joda.time.LocalDate.parse(@requested_date.to_s)
          end

          # conversion for subscription_event_type [type = org.killbill.billing.entitlement.api.SubscriptionEventType]
          @subscription_event_type = Java::org.killbill.billing.entitlement.api.SubscriptionEventType.value_of("#{@subscription_event_type.to_s}") unless @subscription_event_type.nil?

          # conversion for is_blocked_billing [type = boolean]
          @is_blocked_billing = @is_blocked_billing.nil? ? java.lang.Boolean.new(false) : java.lang.Boolean.new(@is_blocked_billing)

          # conversion for is_blocked_entitlement [type = boolean]
          @is_blocked_entitlement = @is_blocked_entitlement.nil? ? java.lang.Boolean.new(false) : java.lang.Boolean.new(@is_blocked_entitlement)

          # conversion for service_name [type = java.lang.String]
          @service_name = @service_name.to_s unless @service_name.nil?

          # conversion for service_state_name [type = java.lang.String]
          @service_state_name = @service_state_name.to_s unless @service_state_name.nil?

          # conversion for prev_product [type = org.killbill.billing.catalog.api.Product]
          @prev_product = @prev_product.to_java unless @prev_product.nil?

          # conversion for prev_plan [type = org.killbill.billing.catalog.api.Plan]
          @prev_plan = @prev_plan.to_java unless @prev_plan.nil?

          # conversion for prev_phase [type = org.killbill.billing.catalog.api.PlanPhase]
          @prev_phase = @prev_phase.to_java unless @prev_phase.nil?

          # conversion for prev_price_list [type = org.killbill.billing.catalog.api.PriceList]
          @prev_price_list = @prev_price_list.to_java unless @prev_price_list.nil?

          # conversion for prev_billing_period [type = org.killbill.billing.catalog.api.BillingPeriod]
          @prev_billing_period = Java::org.killbill.billing.catalog.api.BillingPeriod.value_of("#{@prev_billing_period.to_s}") unless @prev_billing_period.nil?

          # conversion for next_product [type = org.killbill.billing.catalog.api.Product]
          @next_product = @next_product.to_java unless @next_product.nil?

          # conversion for next_plan [type = org.killbill.billing.catalog.api.Plan]
          @next_plan = @next_plan.to_java unless @next_plan.nil?

          # conversion for next_phase [type = org.killbill.billing.catalog.api.PlanPhase]
          @next_phase = @next_phase.to_java unless @next_phase.nil?

          # conversion for next_price_list [type = org.killbill.billing.catalog.api.PriceList]
          @next_price_list = @next_price_list.to_java unless @next_price_list.nil?

          # conversion for next_billing_period [type = org.killbill.billing.catalog.api.BillingPeriod]
          @next_billing_period = Java::org.killbill.billing.catalog.api.BillingPeriod.value_of("#{@next_billing_period.to_s}") unless @next_billing_period.nil?
          self
        end

        def to_ruby(j_obj)
          # conversion for id [type = java.util.UUID]
          @id = j_obj.id
          @id = @id.nil? ? nil : @id.to_s

          # conversion for entitlement_id [type = java.util.UUID]
          @entitlement_id = j_obj.entitlement_id
          @entitlement_id = @entitlement_id.nil? ? nil : @entitlement_id.to_s

          # conversion for effective_date [type = org.joda.time.LocalDate]
          @effective_date = j_obj.effective_date
          if !@effective_date.nil?
            @effective_date = @effective_date.to_s
          end

          # conversion for requested_date [type = org.joda.time.LocalDate]
          @requested_date = j_obj.requested_date
          if !@requested_date.nil?
            @requested_date = @requested_date.to_s
          end

          # conversion for subscription_event_type [type = org.killbill.billing.entitlement.api.SubscriptionEventType]
          @subscription_event_type = j_obj.subscription_event_type
          @subscription_event_type = @subscription_event_type.to_s.to_sym unless @subscription_event_type.nil?

          # conversion for is_blocked_billing [type = boolean]
          @is_blocked_billing = j_obj.is_blocked_billing
          if @is_blocked_billing.nil?
            @is_blocked_billing = false
          else
            tmp_bool = (@is_blocked_billing.java_kind_of? java.lang.Boolean) ? @is_blocked_billing.boolean_value : @is_blocked_billing
            @is_blocked_billing = tmp_bool ? true : false
          end

          # conversion for is_blocked_entitlement [type = boolean]
          @is_blocked_entitlement = j_obj.is_blocked_entitlement
          if @is_blocked_entitlement.nil?
            @is_blocked_entitlement = false
          else
            tmp_bool = (@is_blocked_entitlement.java_kind_of? java.lang.Boolean) ? @is_blocked_entitlement.boolean_value : @is_blocked_entitlement
            @is_blocked_entitlement = tmp_bool ? true : false
          end

          # conversion for service_name [type = java.lang.String]
          @service_name = j_obj.service_name

          # conversion for service_state_name [type = java.lang.String]
          @service_state_name = j_obj.service_state_name

          # conversion for prev_product [type = org.killbill.billing.catalog.api.Product]
          @prev_product = j_obj.prev_product
          @prev_product = Killbill::Plugin::Model::Product.new.to_ruby(@prev_product) unless @prev_product.nil?

          # conversion for prev_plan [type = org.killbill.billing.catalog.api.Plan]
          @prev_plan = j_obj.prev_plan
          @prev_plan = Killbill::Plugin::Model::Plan.new.to_ruby(@prev_plan) unless @prev_plan.nil?

          # conversion for prev_phase [type = org.killbill.billing.catalog.api.PlanPhase]
          @prev_phase = j_obj.prev_phase
          @prev_phase = Killbill::Plugin::Model::PlanPhase.new.to_ruby(@prev_phase) unless @prev_phase.nil?

          # conversion for prev_price_list [type = org.killbill.billing.catalog.api.PriceList]
          @prev_price_list = j_obj.prev_price_list
          @prev_price_list = Killbill::Plugin::Model::PriceList.new.to_ruby(@prev_price_list) unless @prev_price_list.nil?

          # conversion for prev_billing_period [type = org.killbill.billing.catalog.api.BillingPeriod]
          @prev_billing_period = j_obj.prev_billing_period
          @prev_billing_period = @prev_billing_period.to_s.to_sym unless @prev_billing_period.nil?

          # conversion for next_product [type = org.killbill.billing.catalog.api.Product]
          @next_product = j_obj.next_product
          @next_product = Killbill::Plugin::Model::Product.new.to_ruby(@next_product) unless @next_product.nil?

          # conversion for next_plan [type = org.killbill.billing.catalog.api.Plan]
          @next_plan = j_obj.next_plan
          @next_plan = Killbill::Plugin::Model::Plan.new.to_ruby(@next_plan) unless @next_plan.nil?

          # conversion for next_phase [type = org.killbill.billing.catalog.api.PlanPhase]
          @next_phase = j_obj.next_phase
          @next_phase = Killbill::Plugin::Model::PlanPhase.new.to_ruby(@next_phase) unless @next_phase.nil?

          # conversion for next_price_list [type = org.killbill.billing.catalog.api.PriceList]
          @next_price_list = j_obj.next_price_list
          @next_price_list = Killbill::Plugin::Model::PriceList.new.to_ruby(@next_price_list) unless @next_price_list.nil?

          # conversion for next_billing_period [type = org.killbill.billing.catalog.api.BillingPeriod]
          @next_billing_period = j_obj.next_billing_period
          @next_billing_period = @next_billing_period.to_s.to_sym unless @next_billing_period.nil?
          self
        end

      end
    end
  end
end
