/*
 * Copyright 2010-2011 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.payment.api;

import org.testng.annotations.Guice;
import org.testng.annotations.Test;

import com.google.inject.Inject;
import com.ning.billing.account.glue.AccountModuleWithMocks;
import com.ning.billing.invoice.glue.InvoiceModuleWithMocks;
import com.ning.billing.mock.glue.MockJunctionModule;
import com.ning.billing.payment.setup.PaymentTestModuleWithMocks;
import com.ning.billing.util.clock.Clock;

@Guice(modules = { PaymentTestModuleWithMocks.class, AccountModuleWithMocks.class, InvoiceModuleWithMocks.class, MockJunctionModule.class })
@Test(groups = "fast")
public class TestMockPaymentApi extends TestPaymentApi {
    @Inject
    public TestMockPaymentApi(Clock clock) {
        super(clock);
    }
}
