/*
 * Copyright 2010-2013 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.osgi.bundles.analytics.dao.model;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

import com.ning.billing.osgi.bundles.analytics.AnalyticsTestSuiteNoDB;

public class TestBusinessOverdueStatusModelDao extends AnalyticsTestSuiteNoDB {

    @Test(groups = "fast")
    public void testEquals() throws Exception {
        final DateTime endDate = new DateTime(2012, 7, 21, 10, 10, 10, DateTimeZone.UTC);
        final BusinessOverdueStatusModelDao overdueStatusModelDao = new BusinessOverdueStatusModelDao(account,
                                                                                                      bundle,
                                                                                                      blockingState,
                                                                                                      endDate,
                                                                                                      auditLog);
        verifyBusinessModelDaoBase(overdueStatusModelDao);
        //Assert.assertEquals(overdueStatusModelDao.getBlockingStateRecordId(), /* TODO */);
        Assert.assertEquals(overdueStatusModelDao.getBundleId(), bundle.getId());
        Assert.assertEquals(overdueStatusModelDao.getBundleExternalKey(), bundle.getExternalKey());
        Assert.assertEquals(overdueStatusModelDao.getStatus(), blockingState.getStateName());
        Assert.assertEquals(overdueStatusModelDao.getStartDate(), blockingState.getTimestamp());
        Assert.assertEquals(overdueStatusModelDao.getEndDate(), endDate);
    }
}
