/*
 * Copyright 2010-2011 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.util.dao;

import com.ning.billing.util.ChangeType;
import com.ning.billing.util.entity.Entity;

import java.util.UUID;

public class MappedEntity<T extends Entity, K, V> {
    private final Mapper<K, V> mapper;
    private final T entity;
    private final ChangeType changeType;

    public MappedEntity(Mapper<K, V> mapper, T entity, ChangeType changeType) {
        this.mapper = mapper;
        this.entity = entity;
        this.changeType = changeType;
    }

    public K getKey() {
        return mapper.getKey();
    }

    public V getValue() {
        return mapper.getValue();
    }

    public T getEntity() {
        return entity;
    }

    public ChangeType getChangeType() {
        return changeType;
    }

    public UUID getId() {
        return entity.getId();
    }
}
