/*
 * Copyright 2010-2012 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.util.api;

import java.util.List;
import java.util.UUID;

import com.ning.billing.util.audit.AuditLog;
import com.ning.billing.util.dao.ObjectType;

public interface AuditUserApi {

    /**
     * Get all the audit entries for a given object
     *
     * @param objectId   the object id
     * @param objectType the type of object
     * @return all audit entries for that object
     */
    public List<AuditLog> getAuditLogs(final UUID objectId, final ObjectType objectType);
}
