###################################################################################
#                                                                                 #
#                   Copyright 2010-2013 Ning, Inc.                                #
#                                                                                 #
#      Ning licenses this file to you under the Apache License, version 2.0       #
#      (the "License"); you may not use this file except in compliance with the   #
#      License.  You may obtain a copy of the License at:                         #
#                                                                                 #
#          http://www.apache.org/licenses/LICENSE-2.0                             #
#                                                                                 #
#      Unless required by applicable law or agreed to in writing, software        #
#      distributed under the License is distributed on an "AS IS" BASIS, WITHOUT  #
#      WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the  #
#      License for the specific language governing permissions and limitations    #
#      under the License.                                                         #
#                                                                                 #
###################################################################################


#
#                       DO NOT EDIT!!!
#    File automatically generated by killbill-java-parser (git@github.com:killbill/killbill-java-parser.git)
#


module Killbill
  module Plugin
    module Api

      java_package 'org.killbill.billing.payment.api'
      class DirectPaymentApi

        include org.killbill.billing.payment.api.DirectPaymentApi

        def initialize(real_java_api)
          @real_java_api = real_java_api
        end


        java_signature 'Java::org.killbill.billing.payment.api.DirectPayment createAuthorization(Java::org.killbill.billing.account.api.Account, Java::java.util.UUID, Java::java.math.BigDecimal, Java::org.killbill.billing.catalog.api.Currency, Java::java.lang.String, Java::java.lang.Iterable, Java::org.killbill.billing.util.callcontext.CallContext)'
        def create_authorization(account, directPaymentId, amount, currency, externalKey, properties, context)

          # conversion for account [type = org.killbill.billing.account.api.Account]
          account = account.to_java unless account.nil?

          # conversion for directPaymentId [type = java.util.UUID]
          directPaymentId = java.util.UUID.fromString(directPaymentId.to_s) unless directPaymentId.nil?

          # conversion for amount [type = java.math.BigDecimal]
          if amount.nil?
            amount = java.math.BigDecimal::ZERO
          else
            amount = java.math.BigDecimal.new(amount.to_s)
          end

          # conversion for currency [type = org.killbill.billing.catalog.api.Currency]
          currency = Java::org.killbill.billing.catalog.api.Currency.value_of("#{currency.to_s}") unless currency.nil?

          # conversion for externalKey [type = java.lang.String]
          externalKey = externalKey.to_s unless externalKey.nil?

          # conversion for properties [type = java.lang.Iterable]
          tmp = java.util.ArrayList.new
          (properties || []).each do |m|
            # conversion for m [type = org.killbill.billing.payment.api.PluginProperty]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          properties = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.create_authorization(account, directPaymentId, amount, currency, externalKey, properties, context)
            # conversion for res [type = org.killbill.billing.payment.api.DirectPayment]
            res = Killbill::Plugin::Model::DirectPayment.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::org.killbill.billing.payment.api.PaymentApiException => e
            raise Killbill::Plugin::Model::PaymentApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::org.killbill.billing.payment.api.DirectPayment createCapture(Java::org.killbill.billing.account.api.Account, Java::java.util.UUID, Java::java.math.BigDecimal, Java::org.killbill.billing.catalog.api.Currency, Java::java.lang.Iterable, Java::org.killbill.billing.util.callcontext.CallContext)'
        def create_capture(account, directPaymentId, amount, currency, properties, context)

          # conversion for account [type = org.killbill.billing.account.api.Account]
          account = account.to_java unless account.nil?

          # conversion for directPaymentId [type = java.util.UUID]
          directPaymentId = java.util.UUID.fromString(directPaymentId.to_s) unless directPaymentId.nil?

          # conversion for amount [type = java.math.BigDecimal]
          if amount.nil?
            amount = java.math.BigDecimal::ZERO
          else
            amount = java.math.BigDecimal.new(amount.to_s)
          end

          # conversion for currency [type = org.killbill.billing.catalog.api.Currency]
          currency = Java::org.killbill.billing.catalog.api.Currency.value_of("#{currency.to_s}") unless currency.nil?

          # conversion for properties [type = java.lang.Iterable]
          tmp = java.util.ArrayList.new
          (properties || []).each do |m|
            # conversion for m [type = org.killbill.billing.payment.api.PluginProperty]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          properties = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.create_capture(account, directPaymentId, amount, currency, properties, context)
            # conversion for res [type = org.killbill.billing.payment.api.DirectPayment]
            res = Killbill::Plugin::Model::DirectPayment.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::org.killbill.billing.payment.api.PaymentApiException => e
            raise Killbill::Plugin::Model::PaymentApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::org.killbill.billing.payment.api.DirectPayment createPurchase(Java::org.killbill.billing.account.api.Account, Java::java.util.UUID, Java::java.math.BigDecimal, Java::org.killbill.billing.catalog.api.Currency, Java::java.lang.String, Java::java.lang.Iterable, Java::org.killbill.billing.util.callcontext.CallContext)'
        def create_purchase(account, directPaymentId, amount, currency, externalKey, properties, context)

          # conversion for account [type = org.killbill.billing.account.api.Account]
          account = account.to_java unless account.nil?

          # conversion for directPaymentId [type = java.util.UUID]
          directPaymentId = java.util.UUID.fromString(directPaymentId.to_s) unless directPaymentId.nil?

          # conversion for amount [type = java.math.BigDecimal]
          if amount.nil?
            amount = java.math.BigDecimal::ZERO
          else
            amount = java.math.BigDecimal.new(amount.to_s)
          end

          # conversion for currency [type = org.killbill.billing.catalog.api.Currency]
          currency = Java::org.killbill.billing.catalog.api.Currency.value_of("#{currency.to_s}") unless currency.nil?

          # conversion for externalKey [type = java.lang.String]
          externalKey = externalKey.to_s unless externalKey.nil?

          # conversion for properties [type = java.lang.Iterable]
          tmp = java.util.ArrayList.new
          (properties || []).each do |m|
            # conversion for m [type = org.killbill.billing.payment.api.PluginProperty]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          properties = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.create_purchase(account, directPaymentId, amount, currency, externalKey, properties, context)
            # conversion for res [type = org.killbill.billing.payment.api.DirectPayment]
            res = Killbill::Plugin::Model::DirectPayment.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::org.killbill.billing.payment.api.PaymentApiException => e
            raise Killbill::Plugin::Model::PaymentApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::org.killbill.billing.payment.api.DirectPayment createVoid(Java::org.killbill.billing.account.api.Account, Java::java.util.UUID, Java::java.lang.Iterable, Java::org.killbill.billing.util.callcontext.CallContext)'
        def create_void(account, directPaymentId, properties, context)

          # conversion for account [type = org.killbill.billing.account.api.Account]
          account = account.to_java unless account.nil?

          # conversion for directPaymentId [type = java.util.UUID]
          directPaymentId = java.util.UUID.fromString(directPaymentId.to_s) unless directPaymentId.nil?

          # conversion for properties [type = java.lang.Iterable]
          tmp = java.util.ArrayList.new
          (properties || []).each do |m|
            # conversion for m [type = org.killbill.billing.payment.api.PluginProperty]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          properties = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.create_void(account, directPaymentId, properties, context)
            # conversion for res [type = org.killbill.billing.payment.api.DirectPayment]
            res = Killbill::Plugin::Model::DirectPayment.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::org.killbill.billing.payment.api.PaymentApiException => e
            raise Killbill::Plugin::Model::PaymentApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::org.killbill.billing.payment.api.DirectPayment createCredit(Java::org.killbill.billing.account.api.Account, Java::java.util.UUID, Java::java.math.BigDecimal, Java::org.killbill.billing.catalog.api.Currency, Java::java.lang.Iterable, Java::org.killbill.billing.util.callcontext.CallContext)'
        def create_credit(account, directPaymentId, amount, currency, properties, context)

          # conversion for account [type = org.killbill.billing.account.api.Account]
          account = account.to_java unless account.nil?

          # conversion for directPaymentId [type = java.util.UUID]
          directPaymentId = java.util.UUID.fromString(directPaymentId.to_s) unless directPaymentId.nil?

          # conversion for amount [type = java.math.BigDecimal]
          if amount.nil?
            amount = java.math.BigDecimal::ZERO
          else
            amount = java.math.BigDecimal.new(amount.to_s)
          end

          # conversion for currency [type = org.killbill.billing.catalog.api.Currency]
          currency = Java::org.killbill.billing.catalog.api.Currency.value_of("#{currency.to_s}") unless currency.nil?

          # conversion for properties [type = java.lang.Iterable]
          tmp = java.util.ArrayList.new
          (properties || []).each do |m|
            # conversion for m [type = org.killbill.billing.payment.api.PluginProperty]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          properties = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.create_credit(account, directPaymentId, amount, currency, properties, context)
            # conversion for res [type = org.killbill.billing.payment.api.DirectPayment]
            res = Killbill::Plugin::Model::DirectPayment.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::org.killbill.billing.payment.api.PaymentApiException => e
            raise Killbill::Plugin::Model::PaymentApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::java.util.List getAccountPayments(Java::java.util.UUID, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def get_account_payments(accountId, context)

          # conversion for accountId [type = java.util.UUID]
          accountId = java.util.UUID.fromString(accountId.to_s) unless accountId.nil?

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.get_account_payments(accountId, context)
            # conversion for res [type = java.util.List]
            tmp = []
            (res || []).each do |m|
              # conversion for m [type = org.killbill.billing.payment.api.DirectPayment]
              m = Killbill::Plugin::Model::DirectPayment.new.to_ruby(m) unless m.nil?
              tmp << m
            end
            res = tmp
            return res
          rescue Java::org.killbill.billing.payment.api.PaymentApiException => e
            raise Killbill::Plugin::Model::PaymentApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::org.killbill.billing.payment.api.DirectPayment getPayment(Java::java.util.UUID, Java::boolean, Java::java.lang.Iterable, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def get_payment(directPaymentId, withPluginInfo, properties, context)

          # conversion for directPaymentId [type = java.util.UUID]
          directPaymentId = java.util.UUID.fromString(directPaymentId.to_s) unless directPaymentId.nil?

          # conversion for withPluginInfo [type = boolean]
          withPluginInfo = withPluginInfo.nil? ? java.lang.Boolean.new(false) : java.lang.Boolean.new(withPluginInfo)

          # conversion for properties [type = java.lang.Iterable]
          tmp = java.util.ArrayList.new
          (properties || []).each do |m|
            # conversion for m [type = org.killbill.billing.payment.api.PluginProperty]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          properties = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.get_payment(directPaymentId, withPluginInfo, properties, context)
            # conversion for res [type = org.killbill.billing.payment.api.DirectPayment]
            res = Killbill::Plugin::Model::DirectPayment.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::org.killbill.billing.payment.api.PaymentApiException => e
            raise Killbill::Plugin::Model::PaymentApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::org.killbill.billing.util.entity.Pagination getPayments(Java::java.lang.Long, Java::java.lang.Long, Java::java.lang.Iterable, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def get_payments(offset, limit, properties, context)

          # conversion for offset [type = java.lang.Long]
          offset = offset

          # conversion for limit [type = java.lang.Long]
          limit = limit

          # conversion for properties [type = java.lang.Iterable]
          tmp = java.util.ArrayList.new
          (properties || []).each do |m|
            # conversion for m [type = org.killbill.billing.payment.api.PluginProperty]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          properties = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          res = @real_java_api.get_payments(offset, limit, properties, context)
          # conversion for res [type = org.killbill.billing.util.entity.Pagination]
          res = Killbill::Plugin::Model::Pagination.new.to_ruby(res) unless res.nil?
          return res
        end

        java_signature 'Java::org.killbill.billing.util.entity.Pagination searchPayments(Java::java.lang.String, Java::java.lang.Long, Java::java.lang.Long, Java::java.lang.Iterable, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def search_payments(searchKey, offset, limit, properties, context)

          # conversion for searchKey [type = java.lang.String]
          searchKey = searchKey.to_s unless searchKey.nil?

          # conversion for offset [type = java.lang.Long]
          offset = offset

          # conversion for limit [type = java.lang.Long]
          limit = limit

          # conversion for properties [type = java.lang.Iterable]
          tmp = java.util.ArrayList.new
          (properties || []).each do |m|
            # conversion for m [type = org.killbill.billing.payment.api.PluginProperty]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          properties = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          res = @real_java_api.search_payments(searchKey, offset, limit, properties, context)
          # conversion for res [type = org.killbill.billing.util.entity.Pagination]
          res = Killbill::Plugin::Model::Pagination.new.to_ruby(res) unless res.nil?
          return res
        end
      end
    end
  end
end
