/*
 * Copyright 2010-2011 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.util.customfield;

import com.ning.billing.util.dao.MapperBase;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

public class CustomFieldMapper extends MapperBase implements ResultSetMapper<CustomField> {
    @Override
    public CustomField map(int index, ResultSet result, StatementContext context) throws SQLException {
        UUID id = UUID.fromString(result.getString("id"));
        String fieldName = result.getString("field_name");
        String fieldValue = result.getString("field_value");
        String createdBy = result.getString("created_by");
        DateTime createdDate = getDate(result, "created_date");
        String updatedBy = result.getString("updated_by");
        DateTime updatedDate = getDate(result, "updated_date");
        return new StringCustomField(id, createdBy, createdDate, updatedBy, updatedDate, fieldName, fieldValue);
    }
}
