/*
 * Copyright 2010-2011 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.invoice.dao;

import com.ning.billing.catalog.api.Currency;
import com.ning.billing.invoice.api.Invoice;
import com.ning.billing.invoice.api.InvoiceItem;
import org.joda.time.DateTime;

import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;

public interface InvoiceDao {
    void create(Invoice invoice);

    Invoice getById(final UUID id);

    List<Invoice> get();

    List<Invoice> getInvoicesByAccount(final UUID accountId);

    List<Invoice> getInvoicesByAccount(final UUID accountId, final DateTime fromDate);

    List<InvoiceItem> getInvoiceItemsByAccount(final UUID accountId);

    List<Invoice> getInvoicesBySubscription(final UUID subscriptionId);

    List<UUID> getInvoicesForPayment(final DateTime targetDate,
                                     final int numberOfDays);

    BigDecimal getAccountBalance(final UUID accountId);

    void notifySuccessfulPayment(final UUID invoiceId,
                                 final BigDecimal paymentAmount,
                                 final Currency currency,
                                 final UUID paymentId,
                                 final DateTime paymentDate);

    void notifyFailedPayment(final UUID invoiceId,
                             final UUID paymentId,
                             final DateTime paymentAttemptDate);

    List<Invoice> getUnpaidInvoicesByAccountId(final UUID accountId, final DateTime upToDate);

    void test();
}
