/*
 * Copyright 2010-2013 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.invoice.model;

import java.math.BigDecimal;
import java.util.UUID;

import javax.annotation.Nullable;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;

import com.ning.billing.catalog.api.Currency;
import com.ning.billing.invoice.api.InvoiceItem;
import com.ning.billing.invoice.api.InvoiceItemType;

public class FixedPriceInvoiceItem extends InvoiceItemBase {

    public FixedPriceInvoiceItem(final UUID invoiceId, final UUID accountId, @Nullable final UUID bundleId, @Nullable final UUID subscriptionId,
                                 final String planName, final String phaseName,
                                 final LocalDate date, final BigDecimal amount, final Currency currency) {
        this(UUID.randomUUID(), null, invoiceId, accountId, bundleId, subscriptionId, planName, phaseName, date, amount, currency);
    }

    public FixedPriceInvoiceItem(final UUID id, @Nullable final DateTime createdDate, final UUID invoiceId, final UUID accountId, final UUID bundleId,
                                 final UUID subscriptionId, final String planName, final String phaseName,
                                 final LocalDate date, final BigDecimal amount, final Currency currency) {
        super(id, createdDate, invoiceId, accountId, bundleId, subscriptionId, planName, phaseName, date, null, amount, currency);
    }

    @Override
    public String getDescription() {
        if (getPhaseName() == null) {
            return "Fixed price charge";
        } else {
            if (getAmount().compareTo(BigDecimal.ZERO) == 0) {
                return getPhaseName();
            } else {
                return String.format("%s (fixed price)", getPhaseName());
            }
        }
    }

    @Override
    public InvoiceItemType getInvoiceItemType() {
        return InvoiceItemType.FIXED;
    }
}
