###################################################################################
#                                                                                 #
#                   Copyright 2010-2013 Ning, Inc.                                #
#                                                                                 #
#      Ning licenses this file to you under the Apache License, version 2.0       #
#      (the "License"); you may not use this file except in compliance with the   #
#      License.  You may obtain a copy of the License at:                         #
#                                                                                 #
#          http://www.apache.org/licenses/LICENSE-2.0                             #
#                                                                                 #
#      Unless required by applicable law or agreed to in writing, software        #
#      distributed under the License is distributed on an "AS IS" BASIS, WITHOUT  #
#      WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the  #
#      License for the specific language governing permissions and limitations    #
#      under the License.                                                         #
#                                                                                 #
###################################################################################


#
#                       DO NOT EDIT!!!
#    File automatically generated by killbill-java-parser (git@github.com:killbill/killbill-java-parser.git)
#


module Killbill
  module Plugin
    module Api

      java_package 'com.ning.billing.currency.plugin.api'
      class CurrencyPluginApi < JPlugin

        include com.ning.billing.currency.plugin.api.CurrencyPluginApi

        def initialize(real_class_name, services = {})
          super(real_class_name, services)
        end


        java_signature 'Java::java.util.Set getBaseCurrencies()'
        def get_base_currencies()
        begin
          res = @delegate_plugin.get_base_currencies()
          # conversion for res [type = java.util.Set]
          tmp = java.util.TreeSet.new
          (res || []).each do |m|
            # conversion for m [type = com.ning.billing.catalog.api.Currency]
            m = Java::com.ning.billing.catalog.api.Currency.value_of("#{m.to_s}") unless m.nil?
            tmp.add(m)
          end
          res = tmp
          return res
        rescue Exception => e
          message = "Failure in get_base_currencies: #{e}"
          unless e.backtrace.nil?
            message = "#{message}\n#{e.backtrace.join("\n")}"
          end
          logger.warn message
          raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("get_base_currencies failure", e.message)
        ensure
          @delegate_plugin.after_request
        end
      end

      java_signature 'Java::org.joda.time.DateTime getLatestConversionDate(Java::com.ning.billing.catalog.api.Currency)'
      def get_latest_conversion_date(baseCurrency)

        # conversion for baseCurrency [type = com.ning.billing.catalog.api.Currency]
        baseCurrency = baseCurrency.to_s.to_sym unless baseCurrency.nil?
        begin
          res = @delegate_plugin.get_latest_conversion_date(baseCurrency)
          # conversion for res [type = org.joda.time.DateTime]
          if !res.nil?
            res =  (res.kind_of? Time) ? DateTime.parse(res.to_s) : res
            res = Java::org.joda.time.DateTime.new(res.to_s, Java::org.joda.time.DateTimeZone::UTC)
          end
          return res
        rescue Exception => e
          message = "Failure in get_latest_conversion_date: #{e}"
          unless e.backtrace.nil?
            message = "#{message}\n#{e.backtrace.join("\n")}"
          end
          logger.warn message
          raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("get_latest_conversion_date failure", e.message)
        ensure
          @delegate_plugin.after_request
        end
      end

      java_signature 'Java::java.util.SortedSet getConversionDates(Java::com.ning.billing.catalog.api.Currency)'
      def get_conversion_dates(baseCurrency)

        # conversion for baseCurrency [type = com.ning.billing.catalog.api.Currency]
        baseCurrency = baseCurrency.to_s.to_sym unless baseCurrency.nil?
        begin
          res = @delegate_plugin.get_conversion_dates(baseCurrency)
          # conversion for res [type = java.util.SortedSet]
          tmp = java.util.TreeSet.new
          (res || []).each do |m|
            # conversion for m [type = org.joda.time.DateTime]
            if !m.nil?
              m =  (m.kind_of? Time) ? DateTime.parse(m.to_s) : m
              m = Java::org.joda.time.DateTime.new(m.to_s, Java::org.joda.time.DateTimeZone::UTC)
            end
            tmp.add(m)
          end
          res = tmp
          return res
        rescue Exception => e
          message = "Failure in get_conversion_dates: #{e}"
          unless e.backtrace.nil?
            message = "#{message}\n#{e.backtrace.join("\n")}"
          end
          logger.warn message
          raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("get_conversion_dates failure", e.message)
        ensure
          @delegate_plugin.after_request
        end
      end

      java_signature 'Java::java.util.Set getCurrentRates(Java::com.ning.billing.catalog.api.Currency)'
      def get_current_rates(baseCurrency)

        # conversion for baseCurrency [type = com.ning.billing.catalog.api.Currency]
        baseCurrency = baseCurrency.to_s.to_sym unless baseCurrency.nil?
        begin
          res = @delegate_plugin.get_current_rates(baseCurrency)
          # conversion for res [type = java.util.Set]
          tmp = java.util.TreeSet.new
          (res || []).each do |m|
            # conversion for m [type = com.ning.billing.currency.api.Rate]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          res = tmp
          return res
        rescue Exception => e
          message = "Failure in get_current_rates: #{e}"
          unless e.backtrace.nil?
            message = "#{message}\n#{e.backtrace.join("\n")}"
          end
          logger.warn message
          raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("get_current_rates failure", e.message)
        ensure
          @delegate_plugin.after_request
        end
      end

      java_signature 'Java::java.util.Set getRates(Java::com.ning.billing.catalog.api.Currency, Java::org.joda.time.DateTime)'
      def get_rates(baseCurrency, conversionDate)

        # conversion for baseCurrency [type = com.ning.billing.catalog.api.Currency]
        baseCurrency = baseCurrency.to_s.to_sym unless baseCurrency.nil?

        # conversion for conversionDate [type = org.joda.time.DateTime]
        if !conversionDate.nil?
          fmt = Java::org.joda.time.format.ISODateTimeFormat.date_time_no_millis # See https://github.com/killbill/killbill-java-parser/issues/3
          str = fmt.print(conversionDate)
          conversionDate = DateTime.iso8601(str)
        end
        begin
          res = @delegate_plugin.get_rates(baseCurrency, conversionDate)
          # conversion for res [type = java.util.Set]
          tmp = java.util.TreeSet.new
          (res || []).each do |m|
            # conversion for m [type = com.ning.billing.currency.api.Rate]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          res = tmp
          return res
        rescue Exception => e
          message = "Failure in get_rates: #{e}"
          unless e.backtrace.nil?
            message = "#{message}\n#{e.backtrace.join("\n")}"
          end
          logger.warn message
          raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("get_rates failure", e.message)
        ensure
          @delegate_plugin.after_request
        end
      end
    end
  end
end
end
