###################################################################################
#                                                                                 #
#                   Copyright 2010-2013 Ning, Inc.                                #
#                                                                                 #
#      Ning licenses this file to you under the Apache License, version 2.0       #
#      (the "License"); you may not use this file except in compliance with the   #
#      License.  You may obtain a copy of the License at:                         #
#                                                                                 #
#          http://www.apache.org/licenses/LICENSE-2.0                             #
#                                                                                 #
#      Unless required by applicable law or agreed to in writing, software        #
#      distributed under the License is distributed on an "AS IS" BASIS, WITHOUT  #
#      WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the  #
#      License for the specific language governing permissions and limitations    #
#      under the License.                                                         #
#                                                                                 #
###################################################################################


#
#                       DO NOT EDIT!!!
#    File automatically generated by killbill-java-parser (git@github.com:killbill/killbill-java-parser.git)
#


module Killbill
  module Plugin
    module Api

      java_package 'com.ning.billing.payment.plugin.api'
      class PaymentPluginApi < JPlugin

        include com.ning.billing.payment.plugin.api.PaymentPluginApi

        def initialize(real_class_name, services = {})
          super(real_class_name, services)
        end


        java_signature 'Java::com.ning.billing.payment.plugin.api.PaymentInfoPlugin processPayment(Java::java.util.UUID, Java::java.util.UUID, Java::java.util.UUID, Java::java.math.BigDecimal, Java::com.ning.billing.catalog.api.Currency, Java::com.ning.billing.util.callcontext.CallContext)'
        def process_payment(kbAccountId, kbPaymentId, kbPaymentMethodId, amount, currency, context)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for kbPaymentId [type = java.util.UUID]
          kbPaymentId = kbPaymentId.nil? ? nil : kbPaymentId.to_s

          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = kbPaymentMethodId.nil? ? nil : kbPaymentMethodId.to_s

          # conversion for amount [type = java.math.BigDecimal]
          amount = amount.nil? ? 0 : BigDecimal.new(amount.to_s)

          # conversion for currency [type = com.ning.billing.catalog.api.Currency]
          currency = currency.to_s.to_sym unless currency.nil?

          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = Killbill::Plugin::Model::CallContext.new.to_ruby(context) unless context.nil?
          begin
            res = @delegate_plugin.process_payment(kbAccountId, kbPaymentId, kbPaymentMethodId, amount, currency, context)
            # conversion for res [type = com.ning.billing.payment.plugin.api.PaymentInfoPlugin]
            res = res.to_java unless res.nil?
            return res
          rescue Exception => e
            message = "Failure in process_payment: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("process_payment failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::com.ning.billing.payment.plugin.api.PaymentInfoPlugin getPaymentInfo(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.TenantContext)'
        def get_payment_info(kbAccountId, kbPaymentId, context)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for kbPaymentId [type = java.util.UUID]
          kbPaymentId = kbPaymentId.nil? ? nil : kbPaymentId.to_s

          # conversion for context [type = com.ning.billing.util.callcontext.TenantContext]
          context = Killbill::Plugin::Model::TenantContext.new.to_ruby(context) unless context.nil?
          begin
            res = @delegate_plugin.get_payment_info(kbAccountId, kbPaymentId, context)
            # conversion for res [type = com.ning.billing.payment.plugin.api.PaymentInfoPlugin]
            res = res.to_java unless res.nil?
            return res
          rescue Exception => e
            message = "Failure in get_payment_info: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("get_payment_info failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::com.ning.billing.util.entity.Pagination searchPayments(Java::java.lang.String, Java::java.lang.Long, Java::java.lang.Long, Java::com.ning.billing.util.callcontext.TenantContext)'
        def search_payments(searchKey, offset, limit, context)

          # conversion for searchKey [type = java.lang.String]

          # conversion for offset [type = java.lang.Long]

          # conversion for limit [type = java.lang.Long]

          # conversion for context [type = com.ning.billing.util.callcontext.TenantContext]
          context = Killbill::Plugin::Model::TenantContext.new.to_ruby(context) unless context.nil?
          begin
            res = @delegate_plugin.search_payments(searchKey, offset, limit, context)
            # conversion for res [type = com.ning.billing.util.entity.Pagination]
            res = res.to_java unless res.nil?
            return res
          rescue Exception => e
            message = "Failure in search_payments: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("search_payments failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::com.ning.billing.payment.plugin.api.RefundInfoPlugin processRefund(Java::java.util.UUID, Java::java.util.UUID, Java::java.math.BigDecimal, Java::com.ning.billing.catalog.api.Currency, Java::com.ning.billing.util.callcontext.CallContext)'
        def process_refund(kbAccountId, kbPaymentId, refundAmount, currency, context)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for kbPaymentId [type = java.util.UUID]
          kbPaymentId = kbPaymentId.nil? ? nil : kbPaymentId.to_s

          # conversion for refundAmount [type = java.math.BigDecimal]
          refundAmount = refundAmount.nil? ? 0 : BigDecimal.new(refundAmount.to_s)

          # conversion for currency [type = com.ning.billing.catalog.api.Currency]
          currency = currency.to_s.to_sym unless currency.nil?

          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = Killbill::Plugin::Model::CallContext.new.to_ruby(context) unless context.nil?
          begin
            res = @delegate_plugin.process_refund(kbAccountId, kbPaymentId, refundAmount, currency, context)
            # conversion for res [type = com.ning.billing.payment.plugin.api.RefundInfoPlugin]
            res = res.to_java unless res.nil?
            return res
          rescue Exception => e
            message = "Failure in process_refund: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("process_refund failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::java.util.List getRefundInfo(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.TenantContext)'
        def get_refund_info(kbAccountId, kbPaymentId, context)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for kbPaymentId [type = java.util.UUID]
          kbPaymentId = kbPaymentId.nil? ? nil : kbPaymentId.to_s

          # conversion for context [type = com.ning.billing.util.callcontext.TenantContext]
          context = Killbill::Plugin::Model::TenantContext.new.to_ruby(context) unless context.nil?
          begin
            res = @delegate_plugin.get_refund_info(kbAccountId, kbPaymentId, context)
            # conversion for res [type = java.util.List]
            tmp = java.util.ArrayList.new
            (res || []).each do |m|
              # conversion for m [type = com.ning.billing.payment.plugin.api.RefundInfoPlugin]
              m = m.to_java unless m.nil?
              tmp.add(m)
            end
            res = tmp
            return res
          rescue Exception => e
            message = "Failure in get_refund_info: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("get_refund_info failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::com.ning.billing.util.entity.Pagination searchRefunds(Java::java.lang.String, Java::java.lang.Long, Java::java.lang.Long, Java::com.ning.billing.util.callcontext.TenantContext)'
        def search_refunds(searchKey, offset, limit, context)

          # conversion for searchKey [type = java.lang.String]

          # conversion for offset [type = java.lang.Long]

          # conversion for limit [type = java.lang.Long]

          # conversion for context [type = com.ning.billing.util.callcontext.TenantContext]
          context = Killbill::Plugin::Model::TenantContext.new.to_ruby(context) unless context.nil?
          begin
            res = @delegate_plugin.search_refunds(searchKey, offset, limit, context)
            # conversion for res [type = com.ning.billing.util.entity.Pagination]
            res = res.to_java unless res.nil?
            return res
          rescue Exception => e
            message = "Failure in search_refunds: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("search_refunds failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::void addPaymentMethod(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.payment.api.PaymentMethodPlugin, Java::boolean, Java::com.ning.billing.util.callcontext.CallContext)'
        def add_payment_method(kbAccountId, kbPaymentMethodId, paymentMethodProps, setDefault, context)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = kbPaymentMethodId.nil? ? nil : kbPaymentMethodId.to_s

          # conversion for paymentMethodProps [type = com.ning.billing.payment.api.PaymentMethodPlugin]
          paymentMethodProps = Killbill::Plugin::Model::PaymentMethodPlugin.new.to_ruby(paymentMethodProps) unless paymentMethodProps.nil?

          # conversion for setDefault [type = boolean]
          if setDefault.nil?
            setDefault = false
          else
            tmp_bool = (setDefault.java_kind_of? java.lang.Boolean) ? setDefault.boolean_value : setDefault
            setDefault = tmp_bool ? true : false
          end

          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = Killbill::Plugin::Model::CallContext.new.to_ruby(context) unless context.nil?
          begin
            @delegate_plugin.add_payment_method(kbAccountId, kbPaymentMethodId, paymentMethodProps, setDefault, context)
          rescue Exception => e
            message = "Failure in add_payment_method: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("add_payment_method failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::void deletePaymentMethod(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.CallContext)'
        def delete_payment_method(kbAccountId, kbPaymentMethodId, context)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = kbPaymentMethodId.nil? ? nil : kbPaymentMethodId.to_s

          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = Killbill::Plugin::Model::CallContext.new.to_ruby(context) unless context.nil?
          begin
            @delegate_plugin.delete_payment_method(kbAccountId, kbPaymentMethodId, context)
          rescue Exception => e
            message = "Failure in delete_payment_method: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("delete_payment_method failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::com.ning.billing.payment.api.PaymentMethodPlugin getPaymentMethodDetail(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.TenantContext)'
        def get_payment_method_detail(kbAccountId, kbPaymentMethodId, context)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = kbPaymentMethodId.nil? ? nil : kbPaymentMethodId.to_s

          # conversion for context [type = com.ning.billing.util.callcontext.TenantContext]
          context = Killbill::Plugin::Model::TenantContext.new.to_ruby(context) unless context.nil?
          begin
            res = @delegate_plugin.get_payment_method_detail(kbAccountId, kbPaymentMethodId, context)
            # conversion for res [type = com.ning.billing.payment.api.PaymentMethodPlugin]
            res = res.to_java unless res.nil?
            return res
          rescue Exception => e
            message = "Failure in get_payment_method_detail: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("get_payment_method_detail failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::void setDefaultPaymentMethod(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.CallContext)'
        def set_default_payment_method(kbAccountId, kbPaymentMethodId, context)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = kbPaymentMethodId.nil? ? nil : kbPaymentMethodId.to_s

          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = Killbill::Plugin::Model::CallContext.new.to_ruby(context) unless context.nil?
          begin
            @delegate_plugin.set_default_payment_method(kbAccountId, kbPaymentMethodId, context)
          rescue Exception => e
            message = "Failure in set_default_payment_method: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("set_default_payment_method failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::java.util.List getPaymentMethods(Java::java.util.UUID, Java::boolean, Java::com.ning.billing.util.callcontext.CallContext)'
        def get_payment_methods(kbAccountId, refreshFromGateway, context)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for refreshFromGateway [type = boolean]
          if refreshFromGateway.nil?
            refreshFromGateway = false
          else
            tmp_bool = (refreshFromGateway.java_kind_of? java.lang.Boolean) ? refreshFromGateway.boolean_value : refreshFromGateway
            refreshFromGateway = tmp_bool ? true : false
          end

          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = Killbill::Plugin::Model::CallContext.new.to_ruby(context) unless context.nil?
          begin
            res = @delegate_plugin.get_payment_methods(kbAccountId, refreshFromGateway, context)
            # conversion for res [type = java.util.List]
            tmp = java.util.ArrayList.new
            (res || []).each do |m|
              # conversion for m [type = com.ning.billing.payment.plugin.api.PaymentMethodInfoPlugin]
              m = m.to_java unless m.nil?
              tmp.add(m)
            end
            res = tmp
            return res
          rescue Exception => e
            message = "Failure in get_payment_methods: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("get_payment_methods failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::com.ning.billing.util.entity.Pagination searchPaymentMethods(Java::java.lang.String, Java::java.lang.Long, Java::java.lang.Long, Java::com.ning.billing.util.callcontext.TenantContext)'
        def search_payment_methods(searchKey, offset, limit, context)

          # conversion for searchKey [type = java.lang.String]

          # conversion for offset [type = java.lang.Long]

          # conversion for limit [type = java.lang.Long]

          # conversion for context [type = com.ning.billing.util.callcontext.TenantContext]
          context = Killbill::Plugin::Model::TenantContext.new.to_ruby(context) unless context.nil?
          begin
            res = @delegate_plugin.search_payment_methods(searchKey, offset, limit, context)
            # conversion for res [type = com.ning.billing.util.entity.Pagination]
            res = res.to_java unless res.nil?
            return res
          rescue Exception => e
            message = "Failure in search_payment_methods: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("search_payment_methods failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end

        java_signature 'Java::void resetPaymentMethods(Java::java.util.UUID, Java::java.util.List)'
        def reset_payment_methods(kbAccountId, paymentMethods)

          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = kbAccountId.nil? ? nil : kbAccountId.to_s

          # conversion for paymentMethods [type = java.util.List]
          tmp = []
          (paymentMethods || []).each do |m|
            # conversion for m [type = com.ning.billing.payment.plugin.api.PaymentMethodInfoPlugin]
            m = Killbill::Plugin::Model::PaymentMethodInfoPlugin.new.to_ruby(m) unless m.nil?
            tmp << m
          end
          paymentMethods = tmp
          begin
            @delegate_plugin.reset_payment_methods(kbAccountId, paymentMethods)
          rescue Exception => e
            message = "Failure in reset_payment_methods: #{e}"
            unless e.backtrace.nil?
              message = "#{message}\n#{e.backtrace.join("\n")}"
            end
            logger.warn message
            raise Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException.new("reset_payment_methods failure", e.message)
          ensure
            @delegate_plugin.after_request
          end
        end
      end
    end
  end
end
