/*
 * Copyright 2010-2012 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.killbill.billing.util.cache;

// import java.util.HashMap;
// import java.util.Map;

// import javax.inject.Inject;

// import org.killbill.billing.util.cache.Cachable.CacheType;
// import org.slf4j.Logger;
// import org.slf4j.LoggerFactory;

import br.ufrgs.inf.prosoft.cache.*;
import java.util.UUID;
import java.util.List;
import org.killbill.billing.account.api.ImmutableAccountData;

// // Kill Bill generic cache dispatcher
public class CacheControllerDispatcher {

//     private static final Logger logger = LoggerFactory.getLogger(CacheControllerDispatcher.class);

    public static final String CACHE_KEY_SEPARATOR = "::";

public static Caffeine<String, Long> accountRecordIdCacheController = new Caffeine<>("static-multi:CacheControllerDispatcher.accountRecordIdCacheController");
public static Caffeine<String, Long> tenantRecordIdCacheController = new Caffeine<>("static-multi:CacheControllerDispatcher.tenantRecordIdCacheController");
public static Caffeine<String, Long> recordIdCacheController = new Caffeine<>("static-multi:CacheControllerDispatcher.recordIdCacheController");
public static Caffeine<String, List> auditLogViaHistory = new Caffeine<>("static-multi:CacheControllerDispatcher.auditLogViaHistory");
public static Caffeine<String, UUID> objectIdCacheController = new Caffeine<>("static-multi:CacheControllerDispatcher.objectIdCacheController");
public static Caffeine<String, List> auditLog = new Caffeine<>("static-multi:CacheControllerDispatcher.auditLog");
public static Caffeine<UUID, Integer> bcdCacheController = new Caffeine<>("static-multi:CacheControllerDispatcher.bcdCacheController");
public static Caffeine<Long, ImmutableAccountData> accountCacheController = new Caffeine<>("static-multi:CacheControllerDispatcher.accountCacheController");
public static Caffeine<Long, ImmutableAccountData> accountImmutableCacheController = new Caffeine<>("static-multi:CacheControllerDispatcher.accountImmutableCacheController");
public static Caffeine<UUID, UUID> accountIdCacheController = new Caffeine<>("static-multi:CacheControllerDispatcher.accountIdCacheController");
public static Caffeine<UUID, UUID> bundleIdCacheController = new Caffeine<>("static-multi:CacheControllerDispatcher.bundleIdCacheController");

//     private final Map<CacheType, CacheController<Object, Object>> caches;

//     @Inject
//     public CacheControllerDispatcher(final Map<CacheType, CacheController<Object, Object>> caches) {
//         this.caches = caches;
//     }

//     // Test only
//     public CacheControllerDispatcher() {
//         caches = new HashMap<CacheType, CacheController<Object, Object>>();
//     }

//     public <K, V> CacheController<K, V> getCacheController(final CacheType cacheType) {
//         return cast(caches.get(cacheType));
//     }

//     public void clearAll() {
//         for (final CacheController<Object, Object> cacheController : caches.values()) {
//             cacheController.removeAll();
//         }
//     }

//     @SuppressWarnings("unchecked")
//     private static <K, V> CacheController<K, V> cast(final CacheController<?, ?> cache) {
//         return (CacheController<K, V>) cache;
//     }
}
