## Introduction

CloudStore is an open-source e-commerce web application developed following the functional requirements defined by the [TPC-W](http://www.tpc.org/tpcw/) standard, and it's goal is to be used for the analysis of cloud characteristics of systems, such as capacity, scalability, elasticity and efficiency. It was developed as a [Showcase application](http://www.cloudscale-project.eu/about/showcase/) to validate the [CloudScale](http://www.cloudscale-project.eu/) tools that were developed during that project.

The application was developed in Java using the [Spring framework](https://spring.io/) and running on a [Tomcat web application server](https://tomcat.apache.org/), while using a [MySQL database](https://www.mysql.com/).
The needed static files and images can be generated with the ImgGen tool or by any other means, but a default database dump and load generation scripts are available in order to start testing a deployment in a very short time.

Different IaaS, PaaS, Storages and Architectures can be tested with little one little changes to the code.

## Deployment

To deploy CloudStore on public or private cloud you can use our [deployment scripts](https://github.com/CloudScale-Project/Deployment-Scripts). We have also developed the [distributed JMeter](https://github.com/CloudScale-Project/Distributed-Jmeter) scripts in order to load test the CloudStore.

Otherwise, you can hand-install CloudStore in your computer or virtual machines, and generate load with Gatling, or manually by connecting your browser to the deployed site.

## Database

CloudStore uses a MySQL database, which can be generated by running ```Generate.java``` file:

```
$ cd src/main/java/eu/cloudscale/showcase/generate/
$ javac Generate.java
$ java Generate mysql
```

This takes a long time and it's slow. We recommend you to import a previously prepared [SQL dump](http://cloudscale.xlab.si/showcase/dumps/rds-tpcw-dump-latest.sql) into your MySQL database.

## Running

For running CloudStore on your computer you will need Tomcat and MySQL database installed. 
You can also import and run CloudStore from the Eclipse IDE.
Before you can run CloudStore on Tomcat you will need to compile it into a ```.war``` archive. but before compiling the CloudStore you need to edit some configuration files.

### Configs
With the configuration files you can tell CloudStore where it can find the images, and how to connect to database.

##### src/main/resources/app.properties
In this file set the url for CSS, JavaScript and image files:

```eu.cloudscale.files.url.css``` - URL to the folder with CSS files

```eu.cloudscale.files.url.img``` - URL to the folder with image files

```eu.cloudscale.files.url.js``` - URL to the folder with JavaScript files

#### src/main/resources/database/database.aws.hibernate.properties
In this file configure the MySQL database:

```jdbc.driverClassName``` - Set to ```com.mysql.jdbc.ReplicationDriver``` if you want to use master-slave MySQL setup. Otherwise set it to ```com.mysql.jdbc.Driver``` value.

```jdbc.url``` - Connection URL to the host and database. Format is ```jdbc:mysql://<host>/<database_name>```.

**Note:**
If you want to use a master-slave MySQL setup, use ```jdbc:mysql:replication://``` format, otherwise ```jdbc:mysql://```.

```jdbc.username``` - Username to connect to database

```jdbc.password``` - Password for the user to connect to database

```jdbc.hibernate.dialect``` - Hibernate dialect

### Compiling
CloudStore is a Maven project so you will have to install the Maven tool.

When you installed Maven you can compile CloudStore into a ```war``` archive by executing the following command:

```bash
$ mvn clean install
```

from the directory where the ```pom.xml``` file is located.

### Installing
Copy ```target/showcase-1.0.0-BUILD-SNAPSHOT.war``` to Tomcat.

## Using ImgGen tool
Open file ```populate_images``` and edit:

```$NUM_ITEMS``` - How many items/books are in database (default: 10000)

```$DEST_DIR``` - Directory name where to save generated images

```$GEN_CMD``` - Path to ```tpcwIMG``` program for generating the images (default: ImgFiles/tpcwIMG)

Now run the command:

```
$ ./populate_images
```

Copy the directory with the images to somewhere publicly available, and as defined in your configuration.

You can now start CloudStore from Tomcat, and access it with your browser to test it.

## Development

1. Download ZIP archive from GitHub
2. Extract ZIP archive somewhere on your filesystem
2. Open Eclipse
3. Choose File -> Import -> General -> Existing Projects into Workspace
4. Click Browser near ```Select root directory```
5. Click Finish



