package eu.cloudscale.showcase.db.model.hibernate;

// Generated May 16, 2013 3:07:18 PM by Hibernate Tools 4.0.0

import static javax.persistence.GenerationType.IDENTITY;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import eu.cloudscale.showcase.db.model.IItem;
import eu.cloudscale.showcase.db.model.IOrderLine;
import eu.cloudscale.showcase.db.model.IOrders;

/**
 * OrderLine generated by hbm2java
 */
@Entity
@Table( name = "order_line", catalog = "tpcw" )
public class OrderLine implements IOrderLine
{
	private Integer     id;

	private IOrders  orders;

	private IItem    item;

	private Integer olQty;

	private Double olDiscount;

	private String  olComment;

	public OrderLine()
	{
	}

	@Id
	@GeneratedValue( strategy = IDENTITY )
	@Column( name = "OL_ID", unique = true, nullable = false )
	public Integer getOlId()
	{
		return this.id;
	}

	public void setOlId(Integer olId)
	{
		this.id = olId;
	}

	@ManyToOne( targetEntity=Orders.class, fetch = FetchType.EAGER )
	@JoinColumn( name = "OL_O_ID", nullable = false )
	public IOrders getOrders()
	{
		return this.orders;
	}

	public void setOrders(IOrders orders)
	{
		this.orders = orders;
	}

	@ManyToOne( targetEntity=Item.class, fetch = FetchType.EAGER )
	@JoinColumn( name = "OL_I_ID", nullable = false )
	public IItem getItem()
	{
		return this.item;
	}

	public void setItem(IItem item)
	{
		this.item = item;
	}

	@Column( name = "OL_QTY" )
	public Integer getOlQty()
	{
		return this.olQty;
	}

	public void setOlQty(Integer olQty)
	{
		this.olQty = olQty;
	}

	@Column( name = "OL_DISCOUNT" )
	public Double getOlDiscount()
	{
		return this.olDiscount;
	}

	public void setOlDiscount(Double oL_DISCOUNT)
	{
		this.olDiscount = oL_DISCOUNT;
	}

	@Column( name = "OL_COMMENT", length = 100 )
	public String getOlComment()
	{
		return this.olComment;
	}

	public void setOlComment(String olComment)
	{
		this.olComment = olComment;
	}

}
