//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------
package br.ufrgs.inf.bdinetr.domain.escape;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Observable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import br.ufrgs.inf.bdinetr.domain.Router;
import br.ufrgs.inf.bdinetr.domain.RouterComponent;

/**
 * @author Alberto Egon, Ingrid Nunes and Frederico Schardong
 */
public abstract class EscapeRouterComponent extends Observable implements RouterComponent {
	protected final Log log;
	protected final Router router;
	

	public EscapeRouterComponent(Router router) {
		this.router = router;
		this.log = LogFactory.getLog(getClass());
	}

	public void invoke(String remoteOp, Object[] args) {
		String socket_arg = remoteOp;
		
		for (int i = 0; i < args.length; i++) {
			socket_arg += ";" + args[i];
		}

		Object result = null;

		log.info("Sent to server: " + socket_arg);

		try {
			Socket clientSocket = new Socket(router.getIp().getAddress(), router.getPort());
			DataOutputStream outToServer = new DataOutputStream(clientSocket.getOutputStream());
			outToServer.writeBytes(socket_arg);
			
			clientSocket.close();
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}

		log.info("Done");
		//apparently no one needs this return
		//return result;
	}

}
