//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------
package br.ufrgs.inf.bdinetr.agent;

import bdi4jade.annotation.Parameter;
import bdi4jade.annotation.Parameter.Direction;
import bdi4jade.belief.Predicate;
import bdi4jade.goal.BeliefGoal;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalTemplateFactory;
import bdi4jade.plan.DefaultPlan;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.BeliefGoalPlanBody;
import br.ufrgs.inf.bdinetr.domain.Flow;
import br.ufrgs.inf.bdinetr.domain.Ip;
import br.ufrgs.inf.bdinetr.domain.Link;
import br.ufrgs.inf.bdinetr.domain.RateLimiter;
import br.ufrgs.inf.bdinetr.domain.Role;
import br.ufrgs.inf.bdinetr.domain.predicate.FlowRateLimited;
import br.ufrgs.inf.bdinetr.domain.predicate.IpRateLimited;
import br.ufrgs.inf.bdinetr.domain.predicate.LinkRateLimited;

/**
 * @author Ingrid Nunes
 */
public class RateLimiterCapability extends RouterAgentCapability {

	public class LimitFlowRatePlan extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Flow flow;

		@Override
		public void execute() {
			role.limitFlow(flow, FLOW_LIMIT_RATE);
			belief(new FlowRateLimited(flow), true);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(FlowRateLimited flowRateLimited) {
			this.flow = flowRateLimited.getConcept();
		}
	}

	public class LimitIPRatePlan extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void execute() {
			role.limitIp(ip, IP_LIMIT_RATE);
			belief(new IpRateLimited(ip), true);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(IpRateLimited ipRateLimited) {
			this.ip = ipRateLimited.getConcept();
		}
	}

	public class LimitLinkRatePlan extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.limitLink(link, LINK_LIMIT_RATE);
			belief(new LinkRateLimited(link), true);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreIPRatePlan extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void execute() {
			role.unlimitIp(ip);
			belief(new IpRateLimited(ip), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(IpRateLimited ipRateLimited) {
			this.ip = ipRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate1 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate2 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate3 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate4 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate5 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate6 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate7 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate8 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate9 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate10 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate11 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate12 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate13 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate14 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate15 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate16 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public class RestoreLinkRate17 extends BeliefGoalPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Link link;

		@Override
		public void execute() {
			role.unlimitLink(link);
			belief(new LinkRateLimited(link), false);
		}

		@Parameter(direction = Direction.IN)
		public void setBeliefName(LinkRateLimited linkRateLimited) {
			this.link = linkRateLimited.getConcept();
		}
	}

	public static final int FLOW_LIMIT_RATE = 90;
	public static final int IP_LIMIT_RATE = 50;
	public static final int LINK_LIMIT_RATE = 50;
	private static final long serialVersionUID = -1705728861020677126L;

	@bdi4jade.annotation.Plan
	private Plan limitFlowRate;
	@bdi4jade.annotation.Plan
	private Plan limitIpRate;
	@bdi4jade.annotation.Plan
	private Plan limitLinkRate;
	@bdi4jade.annotation.Plan
	private Plan restoreIpRate;
	@bdi4jade.annotation.Plan
	private Plan restoreLinkRate, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17;
	@bdi4jade.annotation.TransientBelief
	private final RateLimiter role;

	public RateLimiterCapability(RateLimiter rateLimiter) {
		this.role = rateLimiter;

		this.limitLinkRate = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.TRUE),
				LimitLinkRatePlan.class);
		this.restoreLinkRate = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};
		this.limitIpRate = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						IpRateLimited.class, Boolean.TRUE),
				LimitIPRatePlan.class);
		this.restoreIpRate = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						IpRateLimited.class, Boolean.FALSE),
				RestoreIPRatePlan.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<IpRateLimited> bg = (BeliefGoal<IpRateLimited>) goal;
				Predicate<IpRateLimited> rateLimited = (Predicate<IpRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return rateLimited != null && rateLimited.getValue();
			};
		};
		this.limitFlowRate = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						FlowRateLimited.class, Boolean.TRUE),
				LimitFlowRatePlan.class);


		this.a1 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate1.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a2 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate2.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a3 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate3.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a4 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate4.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a5 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate5.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a6 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate6.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a7 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate7.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a8 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate8.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a9 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate9.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a10 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate10.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a11 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate11.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a12 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate12.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a13 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate13.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a14 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate14.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a15 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate15.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a16 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate16.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};


		this.a17 = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(
						LinkRateLimited.class, Boolean.FALSE),
				RestoreLinkRate17.class) {
			public boolean isContextApplicable(Goal goal) {
				BeliefGoal<LinkRateLimited> bg = (BeliefGoal<LinkRateLimited>) goal;
				Predicate<LinkRateLimited> rateLimited = (Predicate<LinkRateLimited>) getBeliefBase()
						.getBelief(bg.getBeliefName());
				return (rateLimited != null && rateLimited.getValue());
			};
		};
		
	}

	@Override
	public Role getRole() {
		return Role.RATE_LIMITER;
	}

}
