//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------
package br.ufrgs.inf.bdinetr.agent;

import bdi4jade.annotation.Parameter;
import bdi4jade.annotation.Parameter.Direction;
import bdi4jade.plan.DefaultPlan;
import bdi4jade.plan.Plan;
import bdi4jade.plan.Plan.EndState;
import bdi4jade.plan.planbody.AbstractPlanBody;
import br.ufrgs.inf.bdinetr.domain.FlowExporter;
import br.ufrgs.inf.bdinetr.domain.Ip;
import br.ufrgs.inf.bdinetr.domain.Role;
import br.ufrgs.inf.bdinetr.domain.predicate.FlowExport;

/**
 * @author Ingrid Nunes
 */
public class FlowExporterCapability extends RouterAgentCapability {

	public class ExportFlowsPlanBody extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}

	public class ExportFlowsPlanBody1 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	public class ExportFlowsPlanBody2 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody3 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody4 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody5 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody6 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody7 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody8 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody9 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody10 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody11 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody12 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody13 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody14 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody15 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody16 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}
	
	public class ExportFlowsPlanBody17 extends AbstractPlanBody {
		private static final long serialVersionUID = -3493377510830902961L;

		private Ip ip;

		@Override
		public void action() {
			role.turnFlowExporterOn(ip);
			setEndState(EndState.SUCCESSFUL);
		}

		@Parameter(direction = Direction.IN)
		public void setIp(Ip ip) {
			this.ip = ip;
		}
	}



	private static final long serialVersionUID = -1705728861020677126L;

	@bdi4jade.annotation.Plan
	private Plan exportFlows, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17;
	@bdi4jade.annotation.TransientBelief
	private final FlowExporter role;

	public FlowExporterCapability(FlowExporter flowExporter) {
		this.role = flowExporter;

		this.exportFlows = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody.class);

		this.a1 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody1.class);

		this.a2 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody2.class);

		this.a3 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody3.class);

		this.a4 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody4.class);

		this.a5 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody5.class);

		this.a6 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody6.class);

		this.a7 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody7.class);

		this.a8 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody8.class);

		this.a9 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody9.class);

		this.a10 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody10.class);

		this.a11 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody11.class);

		this.a12 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody12.class);

		this.a13 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody13.class);

		this.a14 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody14.class);

		this.a15 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody15.class);

		this.a16 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody16.class);

		this.a17 = new DefaultPlan(FlowExport.class,
				ExportFlowsPlanBody17.class);
	}

	@Override
	public Role getRole() {
		return Role.FLOW_EXPORTER;
	}

}
