/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.modules.shipping.canadapost;

import ca.canadapost.cpcdp.rating.generated.messages.Messages;
import ca.canadapost.cpcdp.rating.generated.rating.MailingScenario;
import ca.canadapost.cpcdp.rating.generated.rating.PriceQuotes;
import com.salesmanager.core.model.common.Delivery;
import com.salesmanager.core.model.merchant.MerchantStore;
import com.salesmanager.core.model.reference.country.Country;
import com.salesmanager.core.model.shipping.PackageDetails;
import com.salesmanager.core.model.shipping.ShippingConfiguration;
import com.salesmanager.core.model.shipping.ShippingOption;
import com.salesmanager.core.model.shipping.ShippingOrigin;
import com.salesmanager.core.model.shipping.ShippingQuote;
import com.salesmanager.core.model.system.CustomIntegrationConfiguration;
import com.salesmanager.core.model.system.IntegrationConfiguration;
import com.salesmanager.core.model.system.IntegrationModule;
import com.salesmanager.core.model.system.ModuleConfig;
import com.salesmanager.core.modules.integration.IntegrationException;
import com.salesmanager.core.modules.integration.shipping.model.ShippingQuoteModule;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanadaPostQuoteModule
implements ShippingQuoteModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanadaPostQuoteModule.class);
    private static final String CANADA_CODE = "CA";
    private static final String US_CODE = "US";

    public void validateModuleConfiguration(IntegrationConfiguration integrationConfiguration, MerchantStore store) throws IntegrationException {
        ArrayList<String> errorFields = null;
        Map keys = integrationConfiguration.getIntegrationKeys();
        if (keys == null) {
            IntegrationException ex = new IntegrationException(100);
            ex.setErrorFields(errorFields);
            throw ex;
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)keys.get("username")))) {
            errorFields = new ArrayList<String>();
            errorFields.add("username");
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)keys.get("password")))) {
            errorFields = new ArrayList();
            errorFields.add("password");
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)keys.get("account")))) {
            errorFields = new ArrayList();
            errorFields.add("account");
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)keys.get("apikey")))) {
            errorFields = new ArrayList();
            errorFields.add("apikey");
        }
        if (errorFields != null) {
            IntegrationException ex = new IntegrationException(100);
            ex.setErrorFields(errorFields);
            throw ex;
        }
    }

    public CustomIntegrationConfiguration getCustomModuleConfiguration(MerchantStore store) throws IntegrationException {
        return null;
    }

    public List<ShippingOption> getShippingQuotes(ShippingQuote quote, List<PackageDetails> packages, BigDecimal orderTotal, Delivery delivery, ShippingOrigin origin, MerchantStore store, IntegrationConfiguration configuration, IntegrationModule module, ShippingConfiguration shippingConfiguration, Locale locale) throws IntegrationException {
        Object service;
        Validate.notNull((Object)shippingConfiguration, (String)"Module Canadapost is not configured");
        Validate.notNull(packages, (String)"Packages are null");
        Validate.notNull((Object)delivery, (String)"Delivery is null");
        Validate.notNull((Object)origin, (String)"Origin is null");
        Validate.notNull((Object)origin.getPostalCode(), (String)"Origin postal code is null");
        if (StringUtils.isBlank((CharSequence)delivery.getPostalCode())) {
            return null;
        }
        Country country = delivery.getCountry();
        if (!country.getIsoCode().equals(US_CODE) && !country.getIsoCode().equals(CANADA_CODE)) {
            throw new IntegrationException("Canadapost Not configured for shipping in country " + country.getIsoCode());
        }
        Map keys = configuration.getIntegrationKeys();
        Map options = configuration.getIntegrationOptions();
        if (keys == null) {
            throw new IntegrationException("Canadapost missing configuration keys");
        }
        if (options == null) {
            throw new IntegrationException("Canadapost missing configuration options");
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)keys.get("username")))) {
            throw new IntegrationException("Canadapost missing configuration key username");
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)keys.get("password")))) {
            throw new IntegrationException("Canadapost missing configuration key password");
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)keys.get("account")))) {
            throw new IntegrationException("Canadapost missing configuration key account");
        }
        String username = (String)keys.get("username");
        String password = (String)keys.get("password");
        String client = (String)keys.get("account");
        List domesticServices = (List)options.get("services-domestic");
        List intlServices = (List)options.get("services-intl");
        List usaServices = (List)options.get("services-usa");
        String host = null;
        String protocol = null;
        String port = null;
        String url = null;
        String env = configuration.getEnvironment();
        Map moduleConfigsMap = module.getModuleConfigs();
        for (String key : moduleConfigsMap.keySet()) {
            ModuleConfig moduleConfig = (ModuleConfig)moduleConfigsMap.get(key);
            if (!moduleConfig.getEnv().equals(env)) continue;
            host = moduleConfig.getHost();
            protocol = moduleConfig.getScheme();
            port = moduleConfig.getPort();
            url = moduleConfig.getUri();
            break;
        }
        StringBuilder link = new StringBuilder().append(protocol).append("://").append(host).append(":").append(port);
        if (!StringUtils.isBlank(url)) {
            link.append(url);
        }
        Client serviceClient = null;
        DefaultClientConfig config = new DefaultClientConfig();
        serviceClient = Client.create((ClientConfig)config);
        serviceClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        MailingScenario mailingScenario = new MailingScenario();
        mailingScenario.setQuoteType("counter");
        mailingScenario.setOriginPostalCode(origin.getPostalCode().replaceAll("\\s+", "").toUpperCase());
        MailingScenario.Destination destination = new MailingScenario.Destination();
        if (delivery.getCountry().getIsoCode().equals(CANADA_CODE)) {
            if (domesticServices == null || domesticServices.size() == 0) {
                throw new IntegrationException("Canadapost selected domestic services are missing");
            }
            MailingScenario.Destination.Domestic domestic = new MailingScenario.Destination.Domestic();
            domestic.setPostalCode(delivery.getPostalCode().replaceAll("\\s+", "").toUpperCase());
            destination.setDomestic(domestic);
            service = new MailingScenario.Services();
            for (String domesticService : domesticServices) {
                ((MailingScenario.Services)service).getServiceCodes().add(domesticService);
            }
            mailingScenario.setServices((MailingScenario.Services)service);
        } else if (delivery.getCountry().getIsoCode().equals(US_CODE)) {
            if (usaServices == null || usaServices.size() == 0) {
                throw new IntegrationException("Canadapost selected USA services are missing");
            }
            MailingScenario.Destination.UnitedStates unitedStates = new MailingScenario.Destination.UnitedStates();
            unitedStates.setZipCode(delivery.getPostalCode().trim());
            destination.setUnitedStates(unitedStates);
            service = new MailingScenario.Services();
            for (String usaService : usaServices) {
                ((MailingScenario.Services)service).getServiceCodes().add(usaService);
            }
            mailingScenario.setServices((MailingScenario.Services)service);
        } else {
            if (intlServices == null || intlServices.size() == 0) {
                throw new IntegrationException("Canadapost selected International services are missing");
            }
            MailingScenario.Destination.International international = new MailingScenario.Destination.International();
            international.setCountryCode(delivery.getCountry().getIsoCode());
            destination.setInternational(international);
            service = new MailingScenario.Services();
            for (String intlService : intlServices) {
                ((MailingScenario.Services)service).getServiceCodes().add(intlService);
            }
            mailingScenario.setServices((MailingScenario.Services)service);
        }
        mailingScenario.setDestination(destination);
        HashMap<String, ShippingOption> allOptions = new HashMap<String, ShippingOption>();
        for (PackageDetails packageDetail : packages) {
            block27: {
                MailingScenario.ParcelCharacteristics parcelCharacteristics = new MailingScenario.ParcelCharacteristics();
                parcelCharacteristics.setWeight(new BigDecimal(packageDetail.getShippingWeight()));
                MailingScenario.ParcelCharacteristics.Dimensions dimensions = new MailingScenario.ParcelCharacteristics.Dimensions();
                dimensions.setHeight(new BigDecimal(packageDetail.getShippingHeight()));
                dimensions.setWidth(new BigDecimal(packageDetail.getShippingWidth()));
                dimensions.setLength(new BigDecimal(packageDetail.getShippingLength()));
                parcelCharacteristics.setDimensions(dimensions);
                mailingScenario.setParcelCharacteristics(parcelCharacteristics);
                WebResource webResource = serviceClient.resource(link.toString());
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/vnd.cpc.ship.rate-v3+xml"}).header("Content-Type", (Object)"application/vnd.cpc.ship.rate-v3+xml")).acceptLanguage(new String[]{"en-CA"})).post(ClientResponse.class, (Object)mailingScenario);
                InputStream respIS = resp.getEntityInputStream();
                LOGGER.debug("HTTP Response Status: " + resp.getStatus() + " " + resp.getClientResponseStatus());
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{PriceQuotes.class, Messages.class});
                    Object entity = jc.createUnmarshaller().unmarshal(respIS);
                    if (entity instanceof PriceQuotes) {
                        PriceQuotes priceQuotes = (PriceQuotes)entity;
                        for (PriceQuotes.PriceQuote aPriceQuote : priceQuotes.getPriceQuotes()) {
                            ShippingOption option = (ShippingOption)allOptions.get(aPriceQuote.getServiceCode());
                            if (option == null) {
                                option = new ShippingOption();
                                option.setOptionCode(aPriceQuote.getServiceCode());
                                option.setOptionPrice(aPriceQuote.getPriceDetails().getDue());
                                option.setOptionName(aPriceQuote.getServiceName());
                                allOptions.put(aPriceQuote.getServiceCode(), option);
                            } else {
                                BigDecimal due = option.getOptionPrice().add(aPriceQuote.getPriceDetails().getDue());
                                option.setOptionPrice(due);
                            }
                            LOGGER.debug("Service Name: " + aPriceQuote.getServiceName());
                            LOGGER.debug("Price: $" + aPriceQuote.getPriceDetails().getDue());
                        }
                        break block27;
                    }
                    Messages messageData = (Messages)entity;
                    StringBuilder messageBuilder = new StringBuilder();
                    for (Messages.Message aMessage : messageData.getMessage()) {
                        LOGGER.debug("Error Code: " + aMessage.getCode());
                        LOGGER.debug("Error Msg: " + aMessage.getDescription());
                        messageBuilder.append(aMessage.getCode()).append(" - ");
                        messageBuilder.append(aMessage.getDescription()).append(" ");
                    }
                    IntegrationException ex = new IntegrationException(messageBuilder.toString());
                    ex.setErrorCode(99);
                    throw ex;
                }
                catch (Exception e) {
                    IntegrationException ex = new IntegrationException(e);
                    ex.setErrorCode(99);
                    throw ex;
                }
            }
            serviceClient.destroy();
        }
        ArrayList<ShippingOption> shippingOptions = new ArrayList<ShippingOption>(allOptions.values());
        return shippingOptions;
    }
}

