/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services.worker;

import com.shopizer.search.services.IndexKeywordRequest;
import com.shopizer.search.services.field.BooleanField;
import com.shopizer.search.services.field.DoubleField;
import com.shopizer.search.services.field.Field;
import com.shopizer.search.services.field.IntegerField;
import com.shopizer.search.services.field.ListField;
import com.shopizer.search.services.field.LongField;
import com.shopizer.search.services.field.StringField;
import com.shopizer.search.services.impl.SearchDelegate;
import com.shopizer.search.services.worker.DeleteKeywordsImpl;
import com.shopizer.search.services.worker.ExecutionContext;
import com.shopizer.search.services.worker.IndexWorker;
import com.shopizer.search.utils.CustomIndexConfiguration;
import com.shopizer.search.utils.CustomIndexFieldConfiguration;
import com.shopizer.search.utils.DateUtil;
import com.shopizer.search.utils.FileUtil;
import com.shopizer.search.utils.SearchClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class KeywordIndexerImpl
implements IndexWorker {
    @Inject
    DeleteKeywordsImpl deleteKeywordsImpl;
    @Inject
    private SearchDelegate searchDelegate;
    private static Logger log = Logger.getLogger(KeywordIndexerImpl.class);
    private static boolean init = false;
    private List<CustomIndexConfiguration> indexConfigurations = null;
    private static Map<String, CustomIndexConfiguration> indexConfigurationsMap = null;

    public List<CustomIndexConfiguration> getIndexConfigurations() {
        return this.indexConfigurations;
    }

    public void setIndexConfigurations(List<CustomIndexConfiguration> indexConfigurations) {
        this.indexConfigurations = indexConfigurations;
    }

    private synchronized void init() {
        if (init) {
            return;
        }
        init = true;
        try {
            if (this.indexConfigurations != null) {
                Iterator<CustomIndexConfiguration> iterator = this.indexConfigurations.iterator();
                while (iterator.hasNext()) {
                    CustomIndexConfiguration o;
                    CustomIndexConfiguration ic = o = iterator.next();
                    String key = ic.getCreateOnIndexName();
                    if (indexConfigurationsMap == null) {
                        indexConfigurationsMap = new HashMap<String, CustomIndexConfiguration>();
                    }
                    if (StringUtils.isBlank((CharSequence)key)) {
                        log.error((Object)"*********************************************");
                        log.error((Object)"Require property createOnIndexName in keyword indexer");
                        log.error((Object)"*********************************************");
                        continue;
                    }
                    indexConfigurationsMap.put(key, ic);
                    String mappingFile = null;
                    String settingsFile = null;
                    if (!StringUtils.isBlank((CharSequence)ic.getMappingFileName())) {
                        mappingFile = ic.getMappingFileName();
                    }
                    if (!StringUtils.isBlank((CharSequence)ic.getSettingsFileName())) {
                        settingsFile = ic.getSettingsFileName();
                    }
                    if (mappingFile == null && settingsFile == null) continue;
                    String metadata = null;
                    String settingsdata = null;
                    try {
                        if (mappingFile != null) {
                            metadata = FileUtil.readFileAsString(mappingFile);
                        }
                        if (settingsFile != null) {
                            settingsdata = FileUtil.readFileAsString(settingsFile);
                        }
                        if (StringUtils.isBlank((CharSequence)ic.getIndexName()) || this.searchDelegate.indexExist(ic.getCollectionName())) continue;
                        this.searchDelegate.createIndice(metadata, settingsdata, ic.getCollectionName(), ic.getIndexName());
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        log.error((Object)"*********************************************");
                        log.error((Object)e);
                        log.error((Object)"*********************************************");
                        init = false;
                    }
                }
            }
            init = true;
        }
        catch (Exception e) {
            log.error((Object)"*********************************************");
            log.error((Object)e);
            log.error((Object)"*********************************************");
        }
    }

    @Override
    public void execute(SearchClient client, String json, String collection, String object, String id, ExecutionContext context) throws Exception {
        if (!init) {
            this.init();
        }
        try {
            if (indexConfigurationsMap != null && indexConfigurationsMap.containsKey(object)) {
                Map indexData = (Map)context.getObject("indexData");
                CustomIndexConfiguration conf = indexConfigurationsMap.get(object);
                List<CustomIndexFieldConfiguration> fields = conf.getFields();
                if (fields != null) {
                    ArrayList<String> k = null;
                    for (CustomIndexFieldConfiguration o : fields) {
                        String string;
                        CustomIndexFieldConfiguration cifc = o;
                        String fieldName = cifc.getFieldName();
                        if (fieldName.trim().toLowerCase().equals("id") || StringUtils.isBlank((CharSequence)(string = cifc.getFieldType()))) continue;
                        if (string.equals("List")) {
                            try {
                                List keyWords = (List)indexData.get(fieldName);
                                if (keyWords == null) continue;
                                if (k == null) {
                                    k = new ArrayList();
                                }
                                k.addAll(keyWords);
                            }
                            catch (Exception e) {
                                String keyword = (String)indexData.get(fieldName);
                                if (keyword == null) continue;
                                if (k == null) {
                                    k = new ArrayList();
                                }
                                k.add(keyword);
                            }
                            continue;
                        }
                        String keyword = (String)indexData.get(fieldName);
                        if (keyword == null) continue;
                        if (k == null) {
                            k = new ArrayList<String>();
                        }
                        k.add(keyword);
                    }
                    if (k != null) {
                        ArrayList<IndexKeywordRequest> bulks = new ArrayList<IndexKeywordRequest>();
                        StringBuilder kw = new StringBuilder();
                        boolean i = true;
                        for (Object e : k) {
                            IndexKeywordRequest kr = new IndexKeywordRequest();
                            String value = (String)e;
                            if (StringUtils.isBlank((CharSequence)value)) continue;
                            String _id = (String)indexData.get("id");
                            kr.setId(_id);
                            kr.setKey(value);
                            if (conf.getFilters() != null && conf.getFilters().size() > 0) {
                                Iterator<CustomIndexFieldConfiguration> iterator = conf.getFilters().iterator();
                                while (iterator.hasNext()) {
                                    Object ooo;
                                    CustomIndexFieldConfiguration oo;
                                    CustomIndexFieldConfiguration filter = oo = iterator.next();
                                    String fieldName = filter.getFieldName();
                                    String fieldType = filter.getFieldType();
                                    Field f = null;
                                    if (fieldType.equals("List")) {
                                        ooo = (List)indexData.get(fieldName);
                                        f = new ListField();
                                        f.setValue(ooo);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Boolean")) {
                                        String s = (String)indexData.get(fieldName);
                                        Boolean ooo2 = new Boolean(s);
                                        f = new BooleanField();
                                        f.setValue(ooo2);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Integer")) {
                                        ooo = (Integer)indexData.get(fieldName);
                                        f = new IntegerField();
                                        f.setValue(ooo);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Long")) {
                                        ooo = (Long)indexData.get(fieldName);
                                        f = new LongField();
                                        f.setValue(ooo);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Double")) {
                                        ooo = (Double)indexData.get(fieldName);
                                        f = new DoubleField();
                                        f.setValue(ooo);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Date")) {
                                        String d = (String)indexData.get(fieldName);
                                        try {
                                            Date dt = DateUtil.formatDate(d);
                                            f = new DoubleField();
                                            f.setValue(dt);
                                            f.setName(fieldName);
                                            kr.getFilters().add(f);
                                        }
                                        catch (Exception e2) {
                                            log.error((Object)("Invalid date format " + d));
                                        }
                                        continue;
                                    }
                                    ooo = (String)indexData.get(fieldName);
                                    f = new StringField();
                                    f.setValue(((String)ooo).toLowerCase());
                                    f.setName(fieldName);
                                    kr.getFilters().add(f);
                                }
                            }
                            bulks.add(kr);
                        }
                        this.deleteKeywordsImpl.deleteObject(client, conf.getCollectionName(), conf.getIndexName(), id);
                        this.searchDelegate.bulkIndexKeywords(bulks, conf.getCollectionName(), conf.getIndexName());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot index keywords, maybe a timing ussue for no shards available", (Throwable)e);
        }
    }

    @Override
    public void init(SearchClient client) {
        if (!init) {
            this.init();
        }
    }
}

