/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.goal;

import bdi4jade.goal.BeliefNotNullValueGoal;
import bdi4jade.goal.BeliefNotPresentGoal;
import bdi4jade.goal.BeliefPresentGoal;
import bdi4jade.goal.BeliefSetHasValueGoal;
import bdi4jade.goal.BeliefValueGoal;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalTemplate;

public abstract class GoalTemplateFactory {
    public static GoalTemplate goalOfType(final Class<? extends Goal> goalClass) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                return goalClass.isInstance(goal);
            }

            public String toString() {
                return "goal(" + goalClass.getName() + ")";
            }
        };
    }

    public static GoalTemplate hasBelief(final Object beliefName) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefPresentGoal) {
                    BeliefPresentGoal bg = (BeliefPresentGoal)goal;
                    return bg.getBeliefName().equals(beliefName);
                }
                return false;
            }

            public String toString() {
                return "belief(" + beliefName + ")";
            }
        };
    }

    public static GoalTemplate hasBeliefOfType(final Class<?> beliefNameClass) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefPresentGoal) {
                    BeliefPresentGoal bg = (BeliefPresentGoal)goal;
                    return beliefNameClass.isInstance(bg.getBeliefName());
                }
                return false;
            }

            public String toString() {
                return "belief<" + beliefNameClass + ">(?))";
            }
        };
    }

    public static GoalTemplate hasBeliefOfTypeWithNotNullValue(final Class<?> beliefNameClass) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefNotNullValueGoal) {
                    BeliefNotNullValueGoal bg = (BeliefNotNullValueGoal)goal;
                    return beliefNameClass.isInstance(bg.getBeliefName());
                }
                return false;
            }

            public String toString() {
                return "belief<" + beliefNameClass + ">(!null))";
            }
        };
    }

    public static GoalTemplate hasBeliefOfTypeWithNullValue(final Class<?> beliefNameClass) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefValueGoal) {
                    BeliefValueGoal bg = (BeliefValueGoal)goal;
                    return beliefNameClass.isInstance(bg.getBeliefName()) && bg.getValue() == null;
                }
                return false;
            }

            public String toString() {
                return "belief<" + beliefNameClass + ">(null))";
            }
        };
    }

    public static GoalTemplate hasBeliefOfTypeWithValue(final Class<?> beliefNameClass, final Object beliefValue) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefValueGoal) {
                    BeliefValueGoal bg = (BeliefValueGoal)goal;
                    return beliefNameClass.isInstance(bg.getBeliefName()) && beliefValue.equals(bg.getValue());
                }
                return false;
            }

            public String toString() {
                return "belief(<" + beliefNameClass.getName() + ">(" + beliefValue + "))";
            }
        };
    }

    public static GoalTemplate hasBeliefValue(final Object beliefName, final Object beliefValue) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefValueGoal) {
                    BeliefValueGoal bg = (BeliefValueGoal)goal;
                    return bg.getBeliefName().equals(beliefName) && beliefValue.equals(bg.getValue());
                }
                return false;
            }

            public String toString() {
                return "belief(" + beliefName + "(" + beliefValue + "))";
            }
        };
    }

    public static GoalTemplate hasBeliefValueOfType(final Object beliefName, final Class<?> beliefValueClass) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefValueGoal) {
                    BeliefValueGoal bg = (BeliefValueGoal)goal;
                    return bg.getBeliefName().equals(beliefName) && beliefValueClass.isInstance(bg.getValue());
                }
                return false;
            }

            public String toString() {
                return "belief<" + beliefValueClass.getName() + ">(" + beliefName + "(?))";
            }
        };
    }

    public static GoalTemplate hasBeliefWithNotNullValue(final Object beliefName) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefNotNullValueGoal) {
                    BeliefNotNullValueGoal bg = (BeliefNotNullValueGoal)goal;
                    return bg.getBeliefName().equals(beliefName);
                }
                return false;
            }

            public String toString() {
                return "belief(" + beliefName + "(!null))";
            }
        };
    }

    public static GoalTemplate hasBeliefWithNullValue(final Object beliefName) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefValueGoal) {
                    BeliefValueGoal bg = (BeliefValueGoal)goal;
                    return bg.getBeliefName().equals(beliefName) && bg.getValue() == null;
                }
                return false;
            }

            public String toString() {
                return "belief(" + beliefName + "(null))";
            }
        };
    }

    public static GoalTemplate hasNoBelief(final Object beliefName) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefNotPresentGoal) {
                    BeliefNotPresentGoal bg = (BeliefNotPresentGoal)goal;
                    return bg.getBeliefName().equals(beliefName);
                }
                return false;
            }

            public String toString() {
                return "!belief(" + beliefName + ")";
            }
        };
    }

    public static GoalTemplate hasNoBeliefOfType(final Class<?> beliefNameClass) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefNotPresentGoal) {
                    BeliefNotPresentGoal bg = (BeliefNotPresentGoal)goal;
                    return beliefNameClass.isInstance(bg.getBeliefName());
                }
                return false;
            }

            public String toString() {
                return "!belief<" + beliefNameClass + ">(?))";
            }
        };
    }

    public static GoalTemplate hasValueInBeliefSet(final Object beliefName, final Object beliefValue) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefSetHasValueGoal) {
                    BeliefSetHasValueGoal bg = (BeliefSetHasValueGoal)goal;
                    return bg.getBeliefName().equals(beliefName) && beliefValue.equals(bg.getValue());
                }
                return false;
            }

            public String toString() {
                return "beliefSet(" + beliefName + "(" + beliefValue + "))";
            }
        };
    }

    public static GoalTemplate hasValueOfTypeInBeliefSet(final Object beliefName, final Class<?> beliefValueClass) {
        return new GoalTemplate(){

            @Override
            public boolean match(Goal goal) {
                if (goal instanceof BeliefSetHasValueGoal) {
                    BeliefSetHasValueGoal bg = (BeliefSetHasValueGoal)goal;
                    return bg.getBeliefName().equals(beliefName) && beliefValueClass.isInstance(bg.getValue());
                }
                return false;
            }

            public String toString() {
                return "beliefSet<" + beliefValueClass.getName() + ">(" + beliefName + "(?))";
            }
        };
    }
}

