/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.planselection;

import bdi4jade.examples.planselection.Softgoals;
import bdi4jade.examples.planselection.TransportationAgent;
import bdi4jade.examples.planselection.TransportationPlanBody;
import bdi4jade.extension.planselection.utilitybased.PlanContribution;
import bdi4jade.goal.GoalTemplateFactory;
import bdi4jade.plan.DefaultPlan;
import java.util.ArrayList;
import java.util.HashMap;

public class TransportationPlan
extends DefaultPlan {
    public static final double MAX_TIME_TAKEN = 90.0;
    private double beingRobbedProbability;
    private double comfort;
    private double cost;
    private boolean costConstant;
    private double crashProbability;
    private int maxTime;
    private int minTime;

    public TransportationPlan(String id, double crashProbability, double beingRobbedProbability, boolean costConstant, double cost, double comfort, int minTime, int maxTime) {
        super(id, GoalTemplateFactory.goalOfType(TransportationAgent.TransportationGoal.class), TransportationPlanBody.class);
        this.beingRobbedProbability = beingRobbedProbability;
        this.comfort = comfort;
        this.cost = cost;
        this.costConstant = costConstant;
        this.crashProbability = crashProbability;
        this.maxTime = maxTime;
        this.minTime = minTime;
        HashMap contributions = new HashMap();
        ArrayList<PlanContribution> sgContributions = new ArrayList<PlanContribution>();
        sgContributions.add(new PlanContribution(Softgoals.SAFETY, Double.valueOf(crashProbability), Double.valueOf(0.0)));
        sgContributions.add(new PlanContribution(Softgoals.SAFETY, Double.valueOf(1.0 - crashProbability), Double.valueOf(1.0)));
        contributions.put(Softgoals.SAFETY, sgContributions);
        sgContributions = new ArrayList();
        if (costConstant) {
            sgContributions.add(new PlanContribution(Softgoals.COST, Double.valueOf(1.0), Double.valueOf(1.0 - cost)));
        } else {
            sgContributions.add(new PlanContribution(Softgoals.COST, Double.valueOf(crashProbability), Double.valueOf(0.0)));
            sgContributions.add(new PlanContribution(Softgoals.COST, Double.valueOf(1.0 - crashProbability), Double.valueOf(1.0 - cost)));
        }
        contributions.put(Softgoals.COST, sgContributions);
        sgContributions = new ArrayList();
        sgContributions.add(new PlanContribution(Softgoals.COMFORT, Double.valueOf(1.0), Double.valueOf(comfort)));
        contributions.put(Softgoals.COMFORT, sgContributions);
        sgContributions = new ArrayList();
        sgContributions.add(new PlanContribution(Softgoals.SECURITY, Double.valueOf(beingRobbedProbability), Double.valueOf(0.0)));
        sgContributions.add(new PlanContribution(Softgoals.SECURITY, Double.valueOf(1.0 - beingRobbedProbability), Double.valueOf(1.0)));
        contributions.put(Softgoals.SECURITY, sgContributions);
        sgContributions = new ArrayList();
        sgContributions.add(new PlanContribution(Softgoals.PERFORMANCE, Double.valueOf(crashProbability), Double.valueOf(0.0)));
        sgContributions.add(new PlanContribution(Softgoals.PERFORMANCE, Double.valueOf((1.0 - crashProbability) * 0.5), Double.valueOf(1.0 - (double)minTime / 90.0)));
        sgContributions.add(new PlanContribution(Softgoals.PERFORMANCE, Double.valueOf((1.0 - crashProbability) * 0.5), Double.valueOf(1.0 - (double)maxTime / 90.0)));
        contributions.put(Softgoals.PERFORMANCE, sgContributions);
        this.putMetadata(PlanContribution.METADATA_NAME, contributions);
    }

    public double getBeingRobbedProbability() {
        return this.beingRobbedProbability;
    }

    public double getComfort() {
        return this.comfort;
    }

    public double getCost() {
        return this.cost;
    }

    public double getCrashProbability() {
        return this.crashProbability;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public int getMinTime() {
        return this.minTime;
    }

    public boolean isCostConstant() {
        return this.costConstant;
    }
}

