/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.lang.sl.SimpleSLTokenizer;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.MissingParameter;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.domain.RequestFIPAServiceBehaviour;
import jade.lang.acl.ACLMessage;
import jade.util.leap.List;

public class AMSService
extends FIPAService {
    private static Codec c = new SLCodec();
    private static Ontology o = FIPAManagementOntology.getInstance();
    private static ContentManager cm = new ContentManager();

    static void checkIsValid(AMSAgentDescription amsd) throws MissingParameter {
        if (amsd.getName() == null) {
            throw new MissingParameter("ams-agent-description", "name");
        }
        if (amsd.getState() == null) {
            throw new MissingParameter("ams-agent-description", "state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Agent a, AID AMSName, AMSAgentDescription amsd) throws FIPAException {
        ACLMessage request = AMSService.createRequestMessage(a, AMSName);
        if (amsd.getName() == null) {
            amsd.setName(a.getAID());
        }
        if (amsd.getState() == null) {
            amsd.setState("active");
        }
        AMSService.checkIsValid(amsd);
        Register r = new Register();
        r.setDescription(amsd);
        Action act = new Action();
        act.setActor(AMSName);
        act.setAction(r);
        ContentManager contentManager = cm;
        synchronized (contentManager) {
            try {
                cm.fillContent(request, act);
            }
            catch (Exception e) {
                throw new FIPAException("Error encoding REQUEST content. " + e);
            }
        }
        AMSService.doFipaRequestClient(a, request);
    }

    public static void register(Agent a, AMSAgentDescription amsd) throws FIPAException {
        AMSService.register(a, a.getAMS(), amsd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregister(Agent a, AID AMSName, AMSAgentDescription amsd) throws FIPAException {
        ACLMessage request = AMSService.createRequestMessage(a, AMSName);
        if (amsd.getName() == null) {
            amsd.setName(a.getAID());
        }
        if (amsd.getState() == null) {
            amsd.setState("active");
        }
        Deregister d = new Deregister();
        d.setDescription(amsd);
        Action act = new Action();
        act.setActor(AMSName);
        act.setAction(d);
        ContentManager contentManager = cm;
        synchronized (contentManager) {
            try {
                cm.fillContent(request, act);
            }
            catch (Exception e) {
                throw new FIPAException("Error encoding REQUEST content. " + e);
            }
        }
        AMSService.doFipaRequestClient(a, request);
    }

    public static void deregister(Agent a, AMSAgentDescription amsd) throws FIPAException {
        AMSService.deregister(a, a.getAMS(), amsd);
    }

    public static void deregister(Agent a, AID AMSName) throws FIPAException {
        AMSAgentDescription amsd = new AMSAgentDescription();
        amsd.setName(a.getAID());
        AMSService.deregister(a, AMSName, amsd);
    }

    public static void deregister(Agent a) throws FIPAException {
        AMSAgentDescription amsd = new AMSAgentDescription();
        amsd.setName(a.getAID());
        AMSService.deregister(a, amsd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modify(Agent a, AID AMSName, AMSAgentDescription amsd) throws FIPAException {
        ACLMessage request = AMSService.createRequestMessage(a, AMSName);
        if (amsd.getName() == null) {
            amsd.setName(a.getAID());
        }
        AMSService.checkIsValid(amsd);
        Modify m = new Modify();
        m.setDescription(amsd);
        Action act = new Action();
        act.setActor(AMSName);
        act.setAction(m);
        ContentManager contentManager = cm;
        synchronized (contentManager) {
            try {
                cm.fillContent(request, act);
            }
            catch (Exception e) {
                throw new FIPAException("Error encoding REQUEST content. " + e);
            }
        }
        AMSService.doFipaRequestClient(a, request);
    }

    public static void modify(Agent a, AMSAgentDescription amsd) throws FIPAException {
        AMSService.modify(a, a.getAMS(), amsd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMSAgentDescription[] search(Agent a, AID AMSName, AMSAgentDescription amsd, SearchConstraints constraints) throws FIPAException {
        ACLMessage request = AMSService.createRequestMessage(a, AMSName);
        Search s = new Search();
        s.setDescription(amsd);
        s.setConstraints(constraints);
        Action act = new Action();
        act.setActor(AMSName);
        act.setAction(s);
        ContentManager contentManager = cm;
        synchronized (contentManager) {
            try {
                cm.fillContent(request, act);
            }
            catch (Exception e) {
                throw new FIPAException("Error encoding REQUEST content. " + e);
            }
        }
        ACLMessage inform = AMSService.doFipaRequestClient(a, request);
        Result r = null;
        ContentManager contentManager2 = cm;
        synchronized (contentManager2) {
            try {
                r = (Result)cm.extractContent(inform);
            }
            catch (Exception e) {
                throw new FIPAException("Error decoding INFORM content. " + e);
            }
        }
        return AMSService.toArray(r.getItems());
    }

    private static AMSAgentDescription[] toArray(List l) throws FIPAException {
        try {
            AMSAgentDescription[] items = new AMSAgentDescription[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                items[i] = (AMSAgentDescription)l.get(i);
            }
            return items;
        }
        catch (ClassCastException cce) {
            throw new FIPAException("Found items are not AMSAgentDescriptions. " + cce);
        }
    }

    public static AMSAgentDescription[] search(Agent a, AMSAgentDescription amsd, SearchConstraints constraints) throws FIPAException {
        return AMSService.search(a, a.getAMS(), amsd, constraints);
    }

    public static AMSAgentDescription[] search(Agent a, AMSAgentDescription amsd) throws FIPAException {
        SearchConstraints constraints = new SearchConstraints();
        return AMSService.search(a, a.getAMS(), amsd, constraints);
    }

    public static AMSAgentDescription[] search(Agent a, AID AMSName, AMSAgentDescription amsd) throws FIPAException {
        SearchConstraints constraints = new SearchConstraints();
        return AMSService.search(a, AMSName, amsd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, AID AMSName, String actionName, AMSAgentDescription amsd, SearchConstraints constraints) throws FIPAException {
        return new RequestFIPAServiceBehaviour(a, AMSName, actionName, amsd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, String actionName, AMSAgentDescription amsd, SearchConstraints constraints) throws FIPAException {
        return AMSService.getNonBlockingBehaviour(a, a.getAMS(), actionName, amsd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, String actionName) throws FIPAException {
        AMSAgentDescription amsd = new AMSAgentDescription();
        amsd.setName(a.getAID());
        SearchConstraints constraints = new SearchConstraints();
        return AMSService.getNonBlockingBehaviour(a, a.getAMS(), actionName, amsd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, AID amsName, String actionName) throws FIPAException {
        AMSAgentDescription amsd = new AMSAgentDescription();
        amsd.setName(a.getAID());
        SearchConstraints constraints = new SearchConstraints();
        return AMSService.getNonBlockingBehaviour(a, amsName, actionName, amsd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, String actionName, AMSAgentDescription amsd) throws FIPAException {
        SearchConstraints constraints = new SearchConstraints();
        return AMSService.getNonBlockingBehaviour(a, a.getAMS(), actionName, amsd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, AID amsName, String actionName, AMSAgentDescription amsd) throws FIPAException {
        SearchConstraints constraints = new SearchConstraints();
        return AMSService.getNonBlockingBehaviour(a, amsName, actionName, amsd, constraints);
    }

    public static AID getFailedReceiver(Agent a, ACLMessage failure) throws FIPAException {
        if (failure.getPerformative() != 6 || !failure.getSender().equals(a.getAMS())) {
            throw new FIPAException("Invalid AMS FAILURE message");
        }
        try {
            String content = failure.getContent();
            int start = content.indexOf("MTS-error");
            start = content.indexOf("agent-identifier", start);
            SimpleSLTokenizer parser = new SimpleSLTokenizer(content.substring(start));
            return AMSService.parseAID(parser);
        }
        catch (Exception e) {
            throw new FIPAException("Invalid content. " + e);
        }
    }

    public static String getFailureReason(Agent a, ACLMessage failure) throws FIPAException {
        if (failure.getPerformative() != 6 || !failure.getSender().equals(a.getAMS())) {
            throw new FIPAException("Invalid AMS FAILURE message");
        }
        try {
            int end2;
            String content = failure.getContent();
            int start = content.indexOf("MTS-error");
            if (start < 0) {
                throw new FIPAException("Invalid AMS FAILURE message");
            }
            start = content.indexOf("internal-error", start);
            if ((content = content.substring(start = content.indexOf(34, start), end2 = content.indexOf(34, start + 1))).startsWith("Agent not found")) {
                content = "Agent not found";
            } else if (content.startsWith("Agent unreachable")) {
                content = "Agent unreachable";
            } else if (content.startsWith("Service error")) {
                content = "Service error";
            } else if (content.startsWith("Foreign agent with no address")) {
                content = "Foreign agent with no address";
            } else if (content.startsWith("Agent unreachable")) {
                content = "Agent unreachable";
            } else if (content.startsWith("Unexpected error")) {
                content = "Unexpected error";
            }
            return content;
        }
        catch (Exception e) {
            throw new FIPAException("Invalid content. " + e);
        }
    }

    static {
        cm.registerLanguage(c, "fipa-sl0");
        cm.registerOntology(o);
    }
}

