/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.mtp.TransportAddress;

public class JICPAddress
implements TransportAddress {
    protected String host;
    protected String port;
    protected String file;
    protected String anchor;

    public JICPAddress() {
    }

    public JICPAddress(String host, String port, String file, String anchor) {
        this.host = host;
        this.port = port != null ? port : String.valueOf(1099);
        this.file = file;
        this.anchor = anchor;
    }

    public String getProto() {
        return "jicp";
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getFile() {
        return this.file;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof JICPAddress) {
            return this.toString().equals(rhs.toString());
        }
        return false;
    }

    public String toString() {
        StringBuffer address = new StringBuffer();
        address.append("jicp");
        address.append("://");
        address.append(this.host);
        if (this.port != null) {
            address.append(":");
            address.append(this.port);
        }
        if (this.file != null) {
            address.append("/");
            address.append(this.file);
        }
        if (this.anchor != null) {
            address.append("#");
            address.append(this.anchor);
        }
        return address.toString();
    }
}

