package bdi4jade.extension.remediation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import bdi4jade.belief.TransientBelief;

public class ResourcePreferences extends TransientBelief<String, Map<Resource, Double>> {

	public static final String NAME = "ResourcePreferences";

	private static final long serialVersionUID = -3150138426400180011L;

	public ResourcePreferences() {
		super(NAME, new HashMap<Resource, Double>());
	}

	public Double getPreferenceForResource(Resource resource) {
		return this.value.get(resource);
	}

	public Set<Resource> getResources() {
		return getValue().keySet();
	}

	public void setPreferenceForResource(Resource resource, Double preference) {
		this.value.put(resource, preference);
	}

}
