/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.rmi;

import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.ServiceException;
import jade.imtp.rmi.NodeAdapter;
import jade.imtp.rmi.NodeRMI;
import jade.imtp.rmi.RMIIMTPManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

class NodeRMIImpl
extends UnicastRemoteObject
implements NodeRMI {
    private Object terminationLock = new Object();
    private boolean terminating = false;
    private NodeAdapter myNode;

    public NodeRMIImpl(NodeAdapter impl, int port, RMIIMTPManager mgr) throws RemoteException {
        super(port, mgr.getClientSocketFactory(), mgr.getServerSocketFactory());
        this.myNode = impl;
    }

    public Object accept(HorizontalCommand cmd) throws RemoteException, IMTPException {
        try {
            if (this.terminating) {
                throw new IMTPException("Dead node");
            }
            return this.myNode.serveHorizontalCommand(cmd);
        }
        catch (ServiceException se) {
            throw new IMTPException("Service Error", se);
        }
    }

    public void platformManagerDead(String deadPmAddress, String notifyingPmAddr) throws RemoteException, IMTPException {
        if (this.terminating) {
            throw new IMTPException("Dead node");
        }
        this.myNode.platformManagerDead(deadPmAddress, notifyingPmAddr);
    }

    public boolean ping(boolean hang) throws RemoteException {
        if (hang) {
            this.waitTermination();
        }
        return this.terminating;
    }

    public void exit() throws RemoteException {
        this.terminating = true;
        this.notifyTermination();
    }

    public void interrupt() throws RemoteException {
        this.notifyTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTermination() {
        Object object = this.terminationLock;
        synchronized (object) {
            try {
                this.terminationLock.wait();
            }
            catch (InterruptedException ie) {
                System.out.println("PING wait interrupted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTermination() {
        Object object = this.terminationLock;
        synchronized (object) {
            this.terminationLock.notifyAll();
        }
    }
}

