/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.plan;

import bdi4jade.core.MetadataElementImpl;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalTemplate;
import bdi4jade.message.MessageGoal;
import bdi4jade.plan.Plan;
import bdi4jade.plan.PlanLibrary;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractPlan
extends MetadataElementImpl
implements Plan {
    private Set<GoalTemplate> goalTemplates = new HashSet<GoalTemplate>();
    private String id;
    private Set<MessageTemplate> messageTemplates = new HashSet<MessageTemplate>();
    private PlanLibrary planLibrary;

    protected AbstractPlan() {
    }

    public AbstractPlan(String id) {
        this(id, null, null);
    }

    public AbstractPlan(String id, GoalTemplate goalTemplate) {
        this(id, goalTemplate, null);
    }

    public AbstractPlan(String id, GoalTemplate goalTemplate, MessageTemplate messageTemplate) {
        this();
        if (id == null) {
            throw new RuntimeException("Plan id cannot be null.");
        }
        this.id = id;
        if (goalTemplate != null) {
            this.goalTemplates.add(goalTemplate);
        }
        this.initGoalTemplates();
        if (messageTemplate != null) {
            this.messageTemplates.add(messageTemplate);
        }
        this.initMessageTemplates();
    }

    public AbstractPlan(String id, MessageTemplate messageTemplate) {
        this(id, null, messageTemplate);
    }

    public void addGoalTemplate(GoalTemplate goalTemplate) {
        this.goalTemplates.add(goalTemplate);
    }

    public void addMessageTemplate(MessageTemplate messageTemplate) {
        this.messageTemplates.add(messageTemplate);
    }

    @Override
    public boolean canAchieve(Goal goal) {
        boolean canAchieve = false;
        if (goal instanceof MessageGoal) {
            canAchieve = this.canProcess(((MessageGoal)goal).getMessage());
        } else {
            for (GoalTemplate template : this.goalTemplates) {
                if (!template.match(goal)) continue;
                canAchieve = true;
                break;
            }
        }
        return canAchieve ? this.isContextApplicable(goal) : false;
    }

    @Override
    public boolean canProcess(ACLMessage message) {
        for (MessageTemplate template : this.messageTemplates) {
            if (!template.match(message)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Plan)) {
            return false;
        }
        return this.id.equals(((Plan)obj).getId());
    }

    public Set<GoalTemplate> getGoalTemplates() {
        return this.goalTemplates;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Set<MessageTemplate> getMessageTemplates() {
        return this.messageTemplates;
    }

    @Override
    public PlanLibrary getPlanLibrary() {
        return this.planLibrary;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected void initGoalTemplates() {
    }

    protected void initMessageTemplates() {
    }

    @Override
    public boolean isContextApplicable(Goal goal) {
        return true;
    }

    @Override
    public void setPlanLibrary(PlanLibrary planLibrary) {
        this.planLibrary = planLibrary;
    }

    public String toString() {
        return this.id;
    }
}

