//----------------------------------------------------------------------------
// Copyright (C) 2018  João Faccin
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.extension.undo;

import bdi4jade.goal.Goal;
import bdi4jade.plan.planbody.BeliefGoalPlanBody;

/**
 * This class is an extension of the {@link BeliefGoalPlanBody}. It overrides
 * the {@link BeliefGoalPlanBody#dispatchGoal(Goal)} and
 * {@link BeliefGoalPlanBody#dispatchSubgoalAndListen(Goal)} methods in order to
 * set the parent of the subgoal being dispatched.
 * 
 * @author João Faccin
 */
public abstract class RevertingPlanBody extends BeliefGoalPlanBody {

	private static final long serialVersionUID = -678344739581158097L;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * bdi4jade.plan.planbody.AbstractPlanBody#dispatchSubgoal(bdi4jade.goal.Goal)
	 */
	@Override
	public boolean dispatchSubgoal(Goal subgoal) {
		setParentGoal(subgoal);
		return super.dispatchSubgoal(subgoal);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * bdi4jade.plan.planbody.AbstractPlanBody#dispatchSubgoalAndListen(bdi4jade.
	 * goal.Goal)
	 */
	@Override
	public boolean dispatchSubgoalAndListen(Goal subgoal) {
		setParentGoal(subgoal);
		return super.dispatchSubgoalAndListen(subgoal);
	}

	/**
	 * Sets the parent goal of the subgoal being dispatched when it is possible.
	 * 
	 * @param subgoal
	 *            the subgoal whose parent will be set.
	 */
	private void setParentGoal(Goal subgoal) {
		if (this.getCapability() instanceof RevertingCapability) {
			RevertingCapability capability = (RevertingCapability) this.getCapability();
			capability.addParentGoal(subgoal, this.getGoal());
		}
	}

}
