package bdi4jade.examples.undo.plan.request;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import bdi4jade.belief.Belief;
import bdi4jade.belief.TransientPredicate;
import bdi4jade.examples.undo.domain.House;
import bdi4jade.examples.undo.domain.predicate.Locked;
import bdi4jade.examples.undo.plan.AnswerRequestPlanBody;
import bdi4jade.extension.undo.RevertingPlanBody;
import bdi4jade.goal.PredicateGoal;
import bdi4jade.plan.Plan.EndState;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

/**
 * @author jgfaccin
 *
 */
public class RequestDeviceUnlockPlanBody extends RevertingPlanBody {

	private static final long serialVersionUID = 1956459046559097703L;

	private static final Log log = LogFactory.getLog(RequestDeviceUnlockPlanBody.class);

	public static final String MSG_CONTENT = "DOORS_UNLOCK";

	private MessageTemplate mt;
	private boolean sent = false;

	@bdi4jade.annotation.Belief
	private Belief<String, String> doorsAgent;

	@SuppressWarnings("unchecked")
	@Override
	protected void execute() {
		if (!sent) {
			ACLMessage msg = new ACLMessage(ACLMessage.REQUEST);
			msg.setContent(MSG_CONTENT);
			msg.addReceiver(new AID(doorsAgent.getValue(), false));
			msg.setConversationId("cin" + System.currentTimeMillis());
			myAgent.send(msg);
			this.mt = MessageTemplate.MatchConversationId(msg.getConversationId());
			this.sent = true;
			log.info("Request sent to agent " + doorsAgent.getValue() + "!");
		} else {
			ACLMessage reply = myAgent.receive(mt);
			if (reply != null) {
				if (reply.getContent().equals(AnswerRequestPlanBody.SUCCEEDED)) {
					TransientPredicate<Locked> doorsUnlock = (TransientPredicate<Locked>) this.getCapability()
							.getBeliefBase().getBelief(new Locked(House.DOORS));
					doorsUnlock.setValue(false, (PredicateGoal<Locked>) this.getGoal());
					log.info(reply.getSender().getName() + ": " + reply.getContent());
					setEndState(EndState.SUCCESSFUL);
				} else {
					this.sent = false;
				}
			} else {
				block();
			}
		}
	}

	@Override
	public int onEnd() {
		this.sent = false;
		return super.onEnd();
	}

}
