/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.nio.BufferTransformer;
import jade.imtp.leap.nio.NIOJICPConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

class NIOJICPConnectionWrapper
extends NIOJICPConnection {
    private NIOJICPConnection realConnection;
    private Thread ownerThread;

    NIOJICPConnectionWrapper(NIOJICPConnection c) {
        super(true);
        this.realConnection = c;
    }

    void lock() {
        this.ownerThread = Thread.currentThread();
    }

    boolean isLocked() {
        return this.ownerThread != null;
    }

    synchronized void unlock() {
        this.ownerThread = null;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int writePacket(JICPPacket pkt) throws IOException {
        NIOJICPConnectionWrapper nIOJICPConnectionWrapper = this;
        synchronized (nIOJICPConnectionWrapper) {
            while (this.ownerThread != null && this.ownerThread != Thread.currentThread()) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw new IOException("Interrupted while waiting on a locked connection");
                }
            }
        }
        return this.realConnection.writePacket(pkt);
    }

    public final SocketChannel getChannel() {
        return this.realConnection.getChannel();
    }

    public final JICPPacket readPacket() throws IOException {
        return this.realConnection.readPacket();
    }

    public final boolean moreDataAvailable() {
        return this.realConnection.moreDataAvailable();
    }

    public final int writeToChannel(ByteBuffer bb) throws IOException {
        return this.realConnection.writeToChannel(bb);
    }

    public final void close() throws IOException {
        this.unlock();
        this.realConnection.close();
    }

    public final boolean isClosed() {
        return this.realConnection.isClosed();
    }

    public final String getRemoteHost() {
        return this.realConnection.getRemoteHost();
    }

    public final void addBufferTransformer(BufferTransformer transformer) {
        this.realConnection.addBufferTransformer(transformer);
    }
}

