package bdi4jade.examples.undo.plan;

import bdi4jade.examples.undo.domain.House;
import bdi4jade.examples.undo.domain.predicate.Locked;
import bdi4jade.examples.undo.domain.predicate.On;
import bdi4jade.examples.undo.domain.predicate.Open;
import bdi4jade.examples.undo.domain.predicate.TakeOff;
import bdi4jade.extension.undo.RevertingPlanBody;
import bdi4jade.goal.PredicateGoal;

/**
 * @author jgfaccin
 *
 */
public class EvacuateAndVentilatePlanBody extends RevertingPlanBody {

	private static final long serialVersionUID = -2470120034621753974L;

	@Override
	protected void execute() {
		dispatchSubgoal(new PredicateGoal<TakeOff>(new TakeOff(House.ALARM), true));
		dispatchSubgoal(new PredicateGoal<On>(new On(House.LIGHTS), true));
		dispatchSubgoal(new PredicateGoal<Locked>(new Locked(House.DOORS), false));
		dispatchSubgoal(new PredicateGoal<Open>(new Open(House.WINDOWS), true));
		dispatchSubgoal(new PredicateGoal<On>(new On(House.FANS), true));
		block();
	}
}