package bdi4jade.examples.undo.plan.request;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import bdi4jade.belief.Belief;
import bdi4jade.belief.PredicateBelief;
import bdi4jade.belief.TransientPredicate;
import bdi4jade.examples.undo.domain.House;
import bdi4jade.examples.undo.domain.predicate.TakeOff;
import bdi4jade.examples.undo.plan.AnswerRequestPlanBody;
import bdi4jade.extension.undo.RevertingPlanBody;
import bdi4jade.plan.Plan.EndState;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

/**
 * @author jgfaccin
 *
 */
public class RequestDeviceTakeOffPlanBody extends RevertingPlanBody {

	private static final long serialVersionUID = 8041605409336004689L;

	private static final Log log = LogFactory.getLog(RequestDeviceTakeOffPlanBody.class);

	public static final String MSG_CONTENT = "ALARM_TAKE_OFF";

	private MessageTemplate mt;
	private boolean sent = false;

	@bdi4jade.annotation.Belief
	private Belief<String, String> alarmAgent;
	@bdi4jade.annotation.Belief
	private PredicateBelief<TakeOff> alarmTakeOff;

	@SuppressWarnings("unchecked")
	@Override
	protected void execute() {
		if (!sent) {
			ACLMessage msg = new ACLMessage(ACLMessage.REQUEST);
			msg.setContent(MSG_CONTENT);
			msg.addReceiver(new AID(alarmAgent.getValue(), false));
			msg.setConversationId("cin" + System.currentTimeMillis());
			myAgent.send(msg);
			this.mt = MessageTemplate.MatchConversationId(msg.getConversationId());
			this.sent = true;
			log.info("Request sent to agent " + alarmAgent.getValue() + "!");
		} else {
			ACLMessage reply = myAgent.receive(mt);
			if (reply != null) {
				if (reply.getContent().equals(AnswerRequestPlanBody.SUCCEEDED)) {
					TransientPredicate<TakeOff> alarmTakeOff = (TransientPredicate<TakeOff>) this.getCapability()
							.getBeliefBase().getBelief(new TakeOff(House.ALARM));
					alarmTakeOff.setValue(true, this.getGoal());
					log.info(reply.getSender().getName() + ": " + reply.getContent());
					setEndState(EndState.SUCCESSFUL);
				} else {
					this.sent = false;
				}
			} else {
				block();
			}
		}
	}

	@Override
	public int onEnd() {
		this.sent = false;
		return super.onEnd();
	}

}
