/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.CaseInsensitiveString;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.UnreachableException;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.core.messaging.MessagingSlice;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.lang.acl.ACLMessage;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.security.JADESecurityException;
import jade.util.leap.Iterator;

public class LightMessagingService
extends BaseService
implements MessageManager.Channel {
    private static final String[] OWNED_COMMANDS = new String[]{"Send-Message", "Notify-Failure", "Install-MTP", "Uninstall-MTP", "New-MTP", "Dead-MTP", "Set-Platform-Addresses"};
    private AgentContainer myContainer;
    private ServiceComponent localSlice;
    private MessageManager myMessageManager;
    private String platformID;

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.platformID = this.myContainer.getPlatformID();
        this.myMessageManager = MessageManager.instance(p);
        String helperSliceName = p.getParameter("accRouter", "$$$Main-Slice$$$");
        this.localSlice = new ServiceComponent(helperSliceName);
    }

    public String getName() {
        return "jade.core.messaging.Messaging";
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.messaging.MessagingSlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean direction) {
        if (direction) {
            return this.localSlice;
        }
        return null;
    }

    public Sink getCommandSink(boolean side) {
        return null;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public void boot(Profile myProfile) {
    }

    public void deliverNow(GenericMessage msg, AID receiverID) throws UnreachableException {
        try {
            if (this.livesHere(receiverID)) {
                this.localSlice.deliverNow(msg, receiverID);
            } else {
                Iterator addresses = receiverID.getAllAddresses();
                while (addresses.hasNext()) {
                    String address = (String)addresses.next();
                    try {
                        this.forwardMessage(msg, receiverID, address);
                        return;
                    }
                    catch (MTPException mtpe) {
                        System.out.println("Bad address [" + address + "]: trying the next one...");
                    }
                }
                this.notifyFailureToSender(msg, receiverID, new InternalError("No valid address contained within the AID " + receiverID.getName()));
            }
        }
        catch (NotFoundException nfe) {
            this.notifyFailureToSender(msg, receiverID, new InternalError("Agent not found: " + nfe.getMessage()));
        }
        catch (JADESecurityException jse) {
            this.notifyFailureToSender(msg, receiverID, new InternalError("Not authorized: " + jse.getMessage()));
        }
    }

    private boolean livesHere(AID id) {
        String hap = id.getHap();
        return CaseInsensitiveString.equalsIgnoreCase(hap, this.platformID);
    }

    private void forwardMessage(GenericMessage msg, AID receiver, String address) throws MTPException {
        try {
            this.localSlice.routeOut(msg.getEnvelope(), msg.getPayload(), receiver, address);
        }
        catch (IMTPException imtpe) {
            throw new MTPException("Error during message routing", imtpe);
        }
    }

    public void notifyFailureToSender(GenericMessage msg, AID receiver, InternalError ie) {
        GenericCommand cmd = new GenericCommand("Notify-Failure", "jade.core.messaging.Messaging", null);
        cmd.addParam(receiver);
        cmd.addParam(msg);
        cmd.addParam(ie);
        try {
            this.submit(cmd);
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
    }

    private void handleSendMessage(VerticalCommand cmd) throws JADESecurityException {
        Object[] params = cmd.getParams();
        AID sender = (AID)params[0];
        GenericMessage msg = (GenericMessage)params[1];
        AID dest = (AID)params[2];
        msg.setSenderPrincipal(cmd.getPrincipal());
        msg.setSenderCredentials(cmd.getCredentials());
        msg.setSender(sender);
        this.myMessageManager.deliver(msg, dest, this);
    }

    private void handleNotifyFailure(VerticalCommand cmd) throws JADESecurityException {
        Object[] params = cmd.getParams();
        GenericMessage msg = (GenericMessage)params[0];
        AID receiver = (AID)params[1];
        InternalError ie = (InternalError)params[2];
        ACLMessage aclmsg = msg.getACLMessage();
        if (aclmsg.getSender() == null || aclmsg.getSender().equals(this.myContainer.getAMS()) && aclmsg.getPerformative() == 6) {
            return;
        }
        ACLMessage failure = aclmsg.createReply();
        failure.setPerformative(6);
        AID theAMS = this.myContainer.getAMS();
        failure.setSender(theAMS);
        failure.setLanguage("fipa-sl");
        String content = "( (action " + msg.getSender().toString();
        content = content + " (ACLMessage) ) (MTS-error " + receiver + " \"" + ie.getMessage() + "\") )";
        failure.setContent(content);
        try {
            GenericCommand command = new GenericCommand("Send-Message", "jade.core.messaging.Messaging", null);
            command.addParam(theAMS);
            command.addParam(new GenericMessage(failure));
            command.addParam((AID)failure.getAllReceiver().next());
            this.submit(command);
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
    }

    private MTPDescriptor handleInstallMTP(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException, MTPException {
        Object[] params = cmd.getParams();
        String address = (String)params[0];
        ContainerID cid = (ContainerID)params[1];
        String className = (String)params[2];
        MessagingSlice targetSlice = (MessagingSlice)this.getSlice(cid.getName());
        return targetSlice.installMTP(address, className);
    }

    private void handleUninstallMTP(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException, MTPException {
        Object[] params = cmd.getParams();
        String address = (String)params[0];
        ContainerID cid = (ContainerID)params[1];
        MessagingSlice targetSlice = (MessagingSlice)this.getSlice(cid.getName());
        targetSlice.uninstallMTP(address);
    }

    private void handleSetPlatformAddresses(VerticalCommand cmd) {
    }

    protected Service.Slice getFreshSlice(String name) throws ServiceException {
        return super.getFreshSlice(name);
    }

    private class ServiceComponent
    extends Filter
    implements Service.Slice {
        private String myHelperName;
        private MessagingSlice myHelper;

        public ServiceComponent(String helperName) {
            this.myHelperName = helperName;
        }

        public void deliverNow(GenericMessage msg, AID receiverID) throws UnreachableException, NotFoundException, JADESecurityException {
            try {
                if (this.myHelper == null) {
                    this.myHelper = (MessagingSlice)LightMessagingService.this.getSlice(this.myHelperName);
                }
                this.deliverUntilOK(msg, receiverID);
            }
            catch (IMTPException imtpe) {
                throw new UnreachableException("Unreachable network node", imtpe);
            }
            catch (ServiceException se) {
                throw new UnreachableException("Unreachable service slice:", se);
            }
        }

        private void deliverUntilOK(GenericMessage msg, AID receiverID) throws IMTPException, NotFoundException, ServiceException, JADESecurityException {
            boolean ok = false;
            do {
                ContainerID cid;
                MessagingSlice mainSlice = (MessagingSlice)LightMessagingService.this.getSlice("$$$Main-Slice$$$");
                try {
                    cid = mainSlice.getAgentLocation(receiverID);
                }
                catch (IMTPException imtpe) {
                    mainSlice = (MessagingSlice)LightMessagingService.this.getFreshSlice("$$$Main-Slice$$$");
                    cid = mainSlice.getAgentLocation(receiverID);
                }
                MessagingSlice targetSlice = (MessagingSlice)LightMessagingService.this.getSlice(cid.getName());
                try {
                    targetSlice.dispatchLocally(msg.getSender(), msg, receiverID);
                    ok = true;
                }
                catch (NotFoundException nfe) {
                    ok = false;
                }
            } while (!ok);
        }

        public boolean accept(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Send-Message")) {
                    LightMessagingService.this.handleSendMessage(cmd);
                } else if (name.equals("Notify-Failure")) {
                    LightMessagingService.this.handleNotifyFailure(cmd);
                } else if (name.equals("Install-MTP")) {
                    MTPDescriptor result = LightMessagingService.this.handleInstallMTP(cmd);
                    cmd.setReturnValue(result);
                } else if (name.equals("Uninstall-MTP")) {
                    LightMessagingService.this.handleUninstallMTP(cmd);
                } else if (name.equals("Set-Platform-Addresses")) {
                    LightMessagingService.this.handleSetPlatformAddresses(cmd);
                }
            }
            catch (JADESecurityException ae) {
                cmd.setReturnValue(ae);
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
            catch (MTPException mtpe) {
                mtpe.printStackTrace();
            }
            return true;
        }

        public void setBlocking(boolean newState) {
        }

        public boolean isBlocking() {
            return false;
        }

        public void setSkipping(boolean newState) {
        }

        public boolean isSkipping() {
            return false;
        }

        public Service getService() {
            return LightMessagingService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return LightMessagingService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("1")) {
                    AID senderID = (AID)params[0];
                    GenericMessage msg = (GenericMessage)params[1];
                    AID receiverID = (AID)params[2];
                    this.dispatchLocally(senderID, msg, receiverID);
                } else if (cmdName.equals("2")) {
                    Envelope env = (Envelope)params[0];
                    byte[] payload = (byte[])params[1];
                    AID receiverID = (AID)params[2];
                    String address = (String)params[3];
                    this.routeOut(env, payload, receiverID, address);
                } else if (cmdName.equals("3")) {
                    AID agentID = (AID)params[0];
                    cmd.setReturnValue(this.getAgentLocation(agentID));
                } else if (cmdName.equals("4")) {
                    String address = (String)params[0];
                    String className = (String)params[1];
                    cmd.setReturnValue(this.installMTP(address, className));
                } else if (cmdName.equals("5")) {
                    String address = (String)params[0];
                    this.uninstallMTP(address);
                } else if (cmdName.equals("6")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    ContainerID cid = (ContainerID)params[1];
                    this.newMTP(mtp, cid);
                } else if (cmdName.equals("7")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    ContainerID cid = (ContainerID)params[1];
                    this.deadMTP(mtp, cid);
                } else if (cmdName.equals("8")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    String sliceName = (String)params[1];
                    this.addRoute(mtp, sliceName);
                } else if (cmdName.equals("9")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    String sliceName = (String)params[1];
                    this.removeRoute(mtp, sliceName);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            if (cmd instanceof VerticalCommand) {
                return (VerticalCommand)((Object)cmd);
            }
            return null;
        }

        public void dispatchLocally(AID senderAID, GenericMessage msg, AID receiverID) throws IMTPException, NotFoundException {
            boolean found = LightMessagingService.this.myContainer.postMessageToLocalAgent(msg.getACLMessage(), receiverID);
            if (!found) {
                throw new NotFoundException("Messaging service slice failed to find " + receiverID);
            }
        }

        public void routeOut(Envelope env, byte[] payload, AID receiverID, String address) throws IMTPException, MTPException {
            try {
                if (this.myHelper == null) {
                    this.myHelper = (MessagingSlice)LightMessagingService.this.getSlice(this.myHelperName);
                }
                this.myHelper.routeOut(env, payload, receiverID, address);
            }
            catch (ServiceException se) {
                throw new MTPException("No suitable route found for address " + address + ".");
            }
        }

        public ContainerID getAgentLocation(AID agentID) throws IMTPException, NotFoundException {
            throw new NotFoundException("Agent location lookup not supported by this slice");
        }

        public MTPDescriptor installMTP(String address, String className) throws IMTPException, ServiceException, MTPException {
            throw new MTPException("Installing MTPs is not supported by this slice");
        }

        public void uninstallMTP(String address) throws IMTPException, ServiceException, NotFoundException, MTPException {
            throw new MTPException("Uninstalling MTPs is not supported by this slice");
        }

        public void newMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException, ServiceException {
        }

        public void deadMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException, ServiceException {
        }

        public void addRoute(MTPDescriptor mtp, String sliceName) throws IMTPException, ServiceException {
        }

        public void removeRoute(MTPDescriptor mtp, String sliceName) throws IMTPException, ServiceException {
        }
    }
}

