//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.undo.plan.request;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import bdi4jade.belief.Belief;
import bdi4jade.belief.TransientPredicate;
import bdi4jade.examples.undo.domain.House;
import bdi4jade.examples.undo.domain.predicate.TakeOff;
import bdi4jade.examples.undo.plan.AnswerRequestPlanBody;
import bdi4jade.extension.undo.RevertingPlanBody;
import bdi4jade.plan.Plan.EndState;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

/**
 * @author jgfaccin
 *
 */
public class RequestDeviceShutdownPlanBody extends RevertingPlanBody {

	private static final long serialVersionUID = -5910930807426504278L;

	private static final Log log = LogFactory.getLog(RequestDeviceShutdownPlanBody.class);

	public static final String MSG_CONTENT = "ALARM_SHUTDOWN";

	private MessageTemplate mt;
	private boolean sent = false;

	@bdi4jade.annotation.Belief
	private Belief<String, String> alarmAgent;

	@SuppressWarnings("unchecked")
	@Override
	protected void execute() {
		if (!sent) {
			ACLMessage msg = new ACLMessage(ACLMessage.REQUEST);
			msg.setContent(MSG_CONTENT);
			msg.addReceiver(new AID(alarmAgent.getValue(), false));
			msg.setConversationId("cin" + System.currentTimeMillis());
			myAgent.send(msg);
			this.mt = MessageTemplate.MatchConversationId(msg.getConversationId());
			this.sent = true;
			log.info("Request sent to agent " + alarmAgent.getValue() + "!");
		} else {
			ACLMessage reply = myAgent.receive(mt);
			if (reply != null) {
				if (reply.getContent().equals(AnswerRequestPlanBody.SUCCEEDED)) {
					TransientPredicate<TakeOff> alarmTakeOff = (TransientPredicate<TakeOff>) this.getCapability()
							.getBeliefBase().getBelief(new TakeOff(House.ALARM));
					alarmTakeOff.setValue(false, this.getGoal());
					log.info(reply.getSender().getName() + ": " + reply.getContent());
					setEndState(EndState.SUCCESSFUL);
				} else {
					this.sent = false;
				}
			} else {
				block();
			}
		}
	}

	@Override
	public int onEnd() {
		this.sent = false;
		return super.onEnd();
	}

}
