package bdi4jade.examples.undo.plan.request;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import bdi4jade.belief.Belief;
import bdi4jade.belief.PredicateBelief;
import bdi4jade.examples.undo.domain.predicate.Open;
import bdi4jade.examples.undo.plan.AnswerRequestPlanBody;
import bdi4jade.extension.undo.RevertingPlanBody;
import bdi4jade.plan.Plan.EndState;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

/**
 * @author jgfaccin
 *
 */
public class RequestValveClosePlanBody extends RevertingPlanBody {

	private static final long serialVersionUID = -4460070890955780068L;

	private static final Log log = LogFactory.getLog(RequestValveClosePlanBody.class);

	public static final String MSG_CONTENT = "VALVE_CLOSE";

	private MessageTemplate mt;
	private boolean sent = false;

	@bdi4jade.annotation.Belief
	private Belief<String, String> valveAgent;
	@bdi4jade.annotation.Belief
	private PredicateBelief<Open> valveClose;

	@Override
	protected void execute() {
		if (!sent) {
			ACLMessage msg = new ACLMessage(ACLMessage.REQUEST);
			msg.setContent(MSG_CONTENT);
			msg.addReceiver(new AID(valveAgent.getValue(), false));
			msg.setConversationId("cin" + System.currentTimeMillis());
			myAgent.send(msg);
			this.mt = MessageTemplate.and(MessageTemplate.MatchConversationId(msg.getConversationId()),
					MessageTemplate.MatchInReplyTo(msg.getReplyWith()));
			this.sent = true;
			log.info("Request sent to agent " + valveAgent.getValue() + "!");
		} else {
			ACLMessage reply = myAgent.receive(mt);
			if (reply != null) {
				if (reply.getContent().equals(AnswerRequestPlanBody.SUCCEEDED)) {
					valveClose.setValue(Boolean.TRUE, this.getGoal());
					log.info(reply.getSender() + ": " + reply.getContent());
					setEndState(EndState.SUCCESSFUL);
				} else {
					this.sent = false;
				}
			} else {
				block();
			}
		}
	}

	@Override
	public int onEnd() {
		this.sent = false;
		return super.onEnd();
	}

}
