/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import java.util.EventObject;
import java.util.Vector;

public class Event
extends EventObject {
    protected int type;
    private Vector param = null;
    private boolean processed = false;
    private Object processingResult = null;

    public Event(int type, Object source) {
        super(source);
        this.type = type;
    }

    public Event(int type, Object source, Object info) {
        this(type, source);
        this.addParameter(info);
    }

    public int getType() {
        return this.type;
    }

    public void addParameter(Object obj) {
        if (this.param == null) {
            this.param = new Vector();
        }
        this.param.addElement(obj);
    }

    public Object getParameter(int index) {
        if (this.param == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.param.elementAt(index);
    }

    public synchronized Object waitUntilProcessed() throws InterruptedException {
        return this.waitUntilProcessed(0L);
    }

    public synchronized Object waitUntilProcessed(long timeout) throws InterruptedException {
        while (!this.processed) {
            this.wait(timeout);
            if (this.processed) continue;
            throw new InterruptedException("Timeout expired");
        }
        return this.processingResult;
    }

    public synchronized void notifyProcessed(Object result) {
        if (!this.processed) {
            this.processingResult = result;
            this.processed = true;
            this.notifyAll();
        }
    }

    public synchronized void reset() {
        this.processed = false;
        this.processingResult = null;
        if (this.param != null) {
            this.param.removeAllElements();
        }
    }

    public void resetProcessed() {
        this.reset();
    }
}

