/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.blocksworld.plan;

import bdi4jade.annotation.Parameter;
import bdi4jade.event.GoalEvent;
import bdi4jade.examples.blocksworld.BlocksWorldCapability;
import bdi4jade.examples.blocksworld.domain.Clear;
import bdi4jade.examples.blocksworld.domain.On;
import bdi4jade.examples.blocksworld.domain.Thing;
import bdi4jade.goal.BeliefSetHasValueGoal;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.BeliefGoalPlanBody;

public class AchieveOnPlanBody
extends BeliefGoalPlanBody {
    private static final long serialVersionUID = -5919677537834351951L;
    private Step step;
    private Thing thing1;
    private Thing thing2;

    public void execute() {
        switch (this.step) {
            case CLEAR_1: {
                this.dispatchSubgoalAndListen((Goal)new BeliefSetHasValueGoal((Object)"clear", (Object)new Clear(this.thing1)));
                this.step = Step.CLEAR_2;
            }
            case CLEAR_2: {
                if (!this.isSubgoalAchieved()) break;
                this.dispatchSubgoalAndListen((Goal)new BeliefSetHasValueGoal((Object)"clear", (Object)new Clear(this.thing2)));
                this.step = Step.PERFORM_MOVE;
                break;
            }
            case PERFORM_MOVE: {
                if (!this.isSubgoalAchieved()) break;
                this.dispatchSubgoalAndListen(new BlocksWorldCapability.PerformMove(this.thing1, this.thing2));
                this.step = Step.WAIT_DONE;
                break;
            }
            case WAIT_DONE: {
                if (!this.isSubgoalAchieved()) break;
                this.step = Step.DONE;
                break;
            }
        }
    }

    private boolean isSubgoalAchieved() {
        GoalEvent goalEvent = this.getGoalEvent();
        if (goalEvent == null) {
            return false;
        }
        if (!GoalStatus.ACHIEVED.equals((Object)goalEvent.getStatus())) {
            this.setEndState(Plan.EndState.FAILED);
            return false;
        }
        return true;
    }

    public void init() {
        this.step = Step.CLEAR_1;
    }

    @Parameter(direction=Parameter.Direction.IN, mandatory=true)
    public void setValue(On on) {
        this.thing1 = on.getThing1();
        this.thing2 = on.getThing2();
    }

    static enum Step {
        CLEAR_1,
        CLEAR_2,
        DONE,
        PERFORM_MOVE,
        WAIT_DONE;

    }
}

