/*
 * Decompiled with CFR 0.152.
 */
package jade.core.resource;

import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.VerticalCommand;
import jade.core.resource.ResourceManagementHelper;
import jade.core.resource.ResourceManagementSlice;
import jade.core.resource.SingletonResourceManagementHelper;
import jade.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class ResourceManagementService
extends BaseService {
    public static final String NAME = "jade.core.resource.ResourceManagement";
    private ServiceComponent localSlice;
    private ResourceManagementHelper helper;

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.localSlice = new ServiceComponent();
    }

    public void boot(Profile p) throws ServiceException {
        super.boot(p);
        this.helper = new ResourceManagementHelperImpl();
        SingletonResourceManagementHelper.getInstance().addHelper(this.helper);
    }

    public void shutdown() {
        SingletonResourceManagementHelper.getInstance().removeHelper(this.helper);
        this.helper = null;
    }

    public String getName() {
        return NAME;
    }

    public Class getHorizontalInterface() {
        return ResourceManagementSlice.class;
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public ServiceHelper getHelper(Agent a) {
        return this.helper;
    }

    public static ResourceManagementHelper getHelper() {
        return SingletonResourceManagementHelper.getInstance().getHelper();
    }

    private class ResourceManagementHelperImpl
    implements ResourceManagementHelper {
        private ResourceManagementHelperImpl() {
        }

        public void init(Agent a) {
        }

        public byte[] getResource(String name) throws ServiceException, NotFoundException {
            return this.getResource(name, 4, null);
        }

        public byte[] getResource(String name, int fetchMode) throws ServiceException, NotFoundException {
            return this.getResource(name, fetchMode, null);
        }

        public byte[] getResource(String name, String containerName) throws ServiceException, NotFoundException {
            return this.getResource(name, 4, containerName);
        }

        public byte[] getResource(String name, int fetchMode, String containerName) throws ServiceException, NotFoundException {
            byte[] resource;
            ResourceManagementSlice slice;
            if (containerName == null) {
                containerName = "$$$Main-Slice$$$";
            }
            if ((slice = (ResourceManagementSlice)ResourceManagementService.this.getSlice(containerName)) == null) {
                throw new ServiceException("getResource called with a wrong container name (" + containerName + ")");
            }
            try {
                try {
                    resource = slice.getResource(name, fetchMode);
                }
                catch (IMTPException imtpe) {
                    slice = (ResourceManagementSlice)ResourceManagementService.this.getFreshSlice(containerName);
                    resource = slice.getResource(name, fetchMode);
                }
            }
            catch (NotFoundException nfe) {
                throw nfe;
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (Throwable t) {
                throw new ServiceException("Error accessing resource " + name + " from " + slice.getNode().getName() + " with fetch-mode " + fetchMode, t);
            }
            return resource;
        }
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Node getNode() throws ServiceException {
            try {
                return ResourceManagementService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Error retrieving local node", imtpe);
            }
        }

        public Service getService() {
            return ResourceManagementService.this;
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("G")) {
                    String name = (String)params[0];
                    int fetchMode = (Integer)params[1];
                    if (ResourceManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                        ResourceManagementService.this.myLogger.log(Logger.FINE, "Serve getResource " + name + " with fetchMode " + fetchMode);
                    }
                    byte[] resource = this.getResource(name, fetchMode);
                    cmd.setReturnValue(resource);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return null;
        }

        private byte[] getResource(String name, int fetchMode) throws IOException, NotFoundException {
            if (fetchMode == 1) {
                return this.getResourceFromClasspath(name);
            }
            if (fetchMode == 2) {
                return this.getResourceFromFileSystem(name);
            }
            if (fetchMode == 3) {
                return this.getResourceFromShared(name);
            }
            if (fetchMode == 4) {
                byte[] res = null;
                try {
                    res = this.getResourceFromShared(name);
                }
                catch (NotFoundException nfe1) {
                    try {
                        res = this.getResourceFromClasspath(name);
                    }
                    catch (NotFoundException nfe2) {
                        res = this.getResourceFromFileSystem(name);
                    }
                }
                return res;
            }
            ResourceManagementService.this.myLogger.log(Logger.WARNING, "Received getResource " + name + " with unsupported fetchMode " + fetchMode);
            throw new IllegalArgumentException("getResource " + name + " with unsupported fetchMode " + fetchMode);
        }

        private byte[] getResourceFromShared(String name) throws IOException, NotFoundException {
            String sharedFolder = System.getProperty("shared-resources-folder");
            sharedFolder = sharedFolder == null ? "" : sharedFolder + File.separator;
            return this.getResourceFromFileSystem(sharedFolder + name);
        }

        private byte[] getResourceFromFileSystem(String name) throws IOException, NotFoundException {
            return this.getResourceFromFile(new File(name));
        }

        private byte[] getResourceFromClasspath(String name) throws IOException, NotFoundException {
            URL resourceUrl = this.getClass().getClassLoader().getResource(name);
            if (resourceUrl == null) {
                throw new NotFoundException("Resource " + name + " not found in class-path");
            }
            URLConnection uc = resourceUrl.openConnection();
            InputStream is = uc.getInputStream();
            byte[] resource = this.getResourceFromStream(is);
            return resource;
        }

        private byte[] getResourceFromFile(File file) throws IOException, NotFoundException {
            if (!file.exists()) {
                throw new NotFoundException("Resource " + file.getName() + " not found");
            }
            return this.getResourceFromStream(new FileInputStream(file));
        }

        private byte[] getResourceFromStream(InputStream is) throws IOException {
            int offset;
            long length = is.available();
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, Math.min(bytes.length - offset, 524288))) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read the resource");
            }
            is.close();
            return bytes;
        }
    }
}

