/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ConversationList;
import jade.lang.acl.MessageTemplate;

public abstract class SSResponderDispatcher
extends CyclicBehaviour {
    private ConversationList activeConversations;
    private MessageTemplate template;
    private static long cnt = 0L;

    public SSResponderDispatcher(Agent a, MessageTemplate tpl) {
        super(a);
        this.activeConversations = new ConversationList(a);
        this.template = MessageTemplate.and(tpl, this.activeConversations.getMessageTemplate());
    }

    public final void action() {
        ACLMessage msg = this.myAgent.receive(this.template);
        if (msg != null) {
            if (msg.getConversationId() == null) {
                msg.setConversationId(SSResponderDispatcher.createConversationId(this.myAgent.getLocalName()));
            }
            final String convId = msg.getConversationId();
            Behaviour ssResponder = this.createResponder(msg);
            if (ssResponder != null) {
                this.activeConversations.registerConversation(convId);
                SequentialBehaviour sb = new SequentialBehaviour(){
                    private static final long serialVersionUID = 12345678L;

                    public int onEnd() {
                        SSResponderDispatcher.this.activeConversations.deregisterConversation(convId);
                        return super.onEnd();
                    }
                };
                sb.setBehaviourName(convId + "-Responder");
                sb.addSubBehaviour(ssResponder);
                this.addBehaviour(sb);
            }
        } else {
            this.block();
        }
    }

    protected abstract Behaviour createResponder(ACLMessage var1);

    protected void addBehaviour(Behaviour b) {
        this.myAgent.addBehaviour(b);
    }

    private static synchronized String createConversationId(String name) {
        return "C-" + name + '-' + System.currentTimeMillis() + '-' + cnt++;
    }
}

