/*
 * Decompiled with CFR 0.152.
 */
package jade.tools;

import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentState;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SenderBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.core.event.AgentEvent;
import jade.core.event.AgentListener;
import jade.core.event.JADEEvent;
import jade.core.event.MessageEvent;
import jade.core.event.MessageListener;
import jade.core.event.NotificationHelper;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedBehaviour;
import jade.domain.introspection.ChangedAgentState;
import jade.domain.introspection.ChangedBehaviourState;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.Occurred;
import jade.domain.introspection.PostedMessage;
import jade.domain.introspection.ReceivedMessage;
import jade.domain.introspection.RemovedBehaviour;
import jade.domain.introspection.SentMessage;
import jade.domain.introspection.StartNotify;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.tools.ToolAgent;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ToolNotifier
extends ToolAgent
implements MessageListener,
AgentListener {
    private static final int IDLE_STATE = 0;
    private static final int ACTIVE_STATE = 1;
    private static final int TERMINATING_STATE = 2;
    private AID observerAgent;
    private Set observedAgents = new HashSet();
    private HashMap pendingEvents = new HashMap();
    private SequentialBehaviour AMSSubscribe = new SequentialBehaviour();
    private volatile int state = 0;
    private Logger myLogger;

    public ToolNotifier(AID id) {
        this.observerAgent = id;
    }

    protected void toolSetup() {
        this.state = 1;
        this.myLogger = Logger.getMyLogger(this.getName());
        this.AMSSubscribe.addSubBehaviour(new SenderBehaviour(this, this.getSubscribe()));
        this.AMSSubscribe.addSubBehaviour(new NotifierAMSListenerBehaviour());
        this.addBehaviour(this.AMSSubscribe);
    }

    protected void toolTakeDown() {
        this.state = 2;
        this.send(this.getCancel());
        this.notifyAllPendingEvents();
    }

    public void addObservedAgent(AID id) {
        if (!id.equals(this.getAID())) {
            this.observedAgents.add(id);
            this.informStartNotify(id);
        } else {
            this.myLogger.log(Logger.WARNING, "ToolNotifier " + this.getName() + ": Cannot observe myself!");
        }
    }

    public void removeObservedAgent(AID id) {
        this.observedAgents.remove(id);
        this.notifyPendingEvents(id);
        if (this.isEmpty()) {
            this.suicide();
        }
    }

    public AID getObserver() {
        return this.observerAgent;
    }

    public boolean isEmpty() {
        return this.observedAgents.isEmpty();
    }

    private void suicide() {
        try {
            NotificationHelper helper = (NotificationHelper)this.getHelper("jade.core.event.Notification");
            helper.deregisterMessageListener(this);
            helper.deregisterAgentListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.doDelete();
    }

    public void sentMessage(MessageEvent ev) {
        if (this.state == 1) {
            AID sender = ev.getSender();
            AID receiver = ev.getReceiver();
            if (this.observedAgents.contains(sender)) {
                ACLMessage msg = ev.getMessage();
                jade.domain.introspection.ACLMessage m = new jade.domain.introspection.ACLMessage();
                Envelope env = msg.getEnvelope();
                if (env != null) {
                    m.setEnvelope((Envelope)msg.getEnvelope().clone());
                }
                m.setAclRepresentation("fipa.acl.rep.string.std");
                m.setPayload(msg.toString());
                SentMessage sm = new SentMessage();
                sm.setSender(sender);
                sm.setReceiver(receiver);
                sm.setMessage(m);
                this.sendEvent(sm, null);
            }
        }
    }

    public void postedMessage(MessageEvent ev) {
        if (this.state == 1) {
            AID sender = ev.getSender();
            AID receiver = ev.getReceiver();
            if (this.observedAgents.contains(receiver)) {
                ACLMessage msg = ev.getMessage();
                jade.domain.introspection.ACLMessage m = new jade.domain.introspection.ACLMessage();
                Envelope env = msg.getEnvelope();
                if (env != null) {
                    m.setEnvelope(msg.getEnvelope());
                    m.setAclRepresentation("fipa.acl.rep.string.std");
                }
                m.setPayload(msg.toString());
                PostedMessage pm = new PostedMessage();
                pm.setSender(sender);
                pm.setReceiver(receiver);
                pm.setMessage(m);
                this.sendEvent(pm, null);
            }
        }
    }

    public void receivedMessage(MessageEvent ev) {
        if (this.state == 1) {
            AID sender = ev.getSender();
            AID receiver = ev.getReceiver();
            if (this.observedAgents.contains(receiver)) {
                ACLMessage msg = ev.getMessage();
                jade.domain.introspection.ACLMessage m = new jade.domain.introspection.ACLMessage();
                Envelope env = msg.getEnvelope();
                if (env != null) {
                    m.setEnvelope(msg.getEnvelope());
                    m.setAclRepresentation("fipa.acl.rep.string.std");
                }
                m.setPayload(msg.toString());
                ReceivedMessage rm = new ReceivedMessage();
                rm.setSender(sender);
                rm.setReceiver(receiver);
                rm.setMessage(m);
                this.sendEvent(rm, null);
            }
        }
    }

    public void routedMessage(MessageEvent ev) {
    }

    public void changedAgentState(AgentEvent ev) {
        AID id;
        if (this.state == 1 && this.observedAgents.contains(id = ev.getAgent())) {
            AgentState from = ev.getFrom();
            AgentState to = ev.getTo();
            ChangedAgentState cas = new ChangedAgentState();
            cas.setAgent(id);
            cas.setFrom(from);
            cas.setTo(to);
            this.sendEvent(cas, null);
        }
    }

    public void addedBehaviour(AgentEvent ev) {
        AID id;
        if (this.state == 1 && this.observedAgents.contains(id = ev.getAgent())) {
            AddedBehaviour ab = new AddedBehaviour();
            ab.setAgent(id);
            ab.setBehaviour(ev.getBehaviour());
            this.sendEvent(ab, null);
        }
    }

    public void removedBehaviour(AgentEvent ev) {
        AID id;
        if (this.state == 1 && this.observedAgents.contains(id = ev.getAgent())) {
            RemovedBehaviour rb = new RemovedBehaviour();
            rb.setAgent(id);
            rb.setBehaviour(ev.getBehaviour());
            this.sendEvent(rb, null);
        }
    }

    public void changedBehaviourState(AgentEvent ev) {
        AID id;
        if (this.state == 1 && this.observedAgents.contains(id = ev.getAgent())) {
            ChangedBehaviourState cs = new ChangedBehaviourState();
            cs.setAgent(id);
            cs.setBehaviour(ev.getBehaviour());
            cs.setFrom(ev.getBehaviourFrom());
            cs.setTo(ev.getBehaviourTo());
            if (ev.getBehaviourTo().equals("RUNNING") && ev.getBehaviour().isSimple()) {
                ev.reset();
                this.addPendingEvent(ev, id);
                this.addBehaviour(new SynchEventInformer(this, cs, ev));
                try {
                    ev.waitUntilProcessed();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                return;
            }
            this.sendEvent(cs, null);
        }
    }

    public void changedAgentPrincipal(AgentEvent ev) {
    }

    private final ACLMessage createObserverMessage() {
        ACLMessage msg = new ACLMessage(7);
        msg.addReceiver(this.observerAgent);
        msg.setOntology("JADE-Introspection");
        msg.setLanguage("fipa-sl0");
        return msg;
    }

    private void informStartNotify(final AID id) {
        if (this.state == 1) {
            StartNotify sn = new StartNotify();
            sn.setObserved(id);
            Action a = new Action();
            a.setAction(sn);
            a.setActor(this.getAID());
            Done d = new Done();
            d.setAction(a);
            ACLMessage msg = this.createObserverMessage();
            try {
                this.getContentManager().fillContent(msg, d);
                msg.setConversationId(this.observerAgent.getName() + "-control");
                this.send(msg);
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        } else {
            this.addBehaviour(new OneShotBehaviour(this){

                public void action() {
                    ToolNotifier.this.informStartNotify(id);
                }
            });
        }
    }

    private void sendEvent(Event ev, String replyWith) {
        if (this.state == 1) {
            EventRecord er = new EventRecord(ev, this.here());
            Occurred o = new Occurred();
            o.setWhat(er);
            ACLMessage msg = this.createObserverMessage();
            try {
                this.getContentManager().fillContent(msg, o);
                msg.setConversationId(this.observerAgent.getName() + "-event");
                if (replyWith != null) {
                    msg.setReplyWith(replyWith);
                } else {
                    msg.addUserDefinedParameter("JADE-ignore-failure", "true");
                }
                this.send(msg);
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingEvent(JADEEvent ev, AID id) {
        HashMap hashMap = this.pendingEvents;
        synchronized (hashMap) {
            List l = (List)this.pendingEvents.get(id);
            if (l == null) {
                l = new ArrayList();
                this.pendingEvents.put(id, l);
            }
            l.add(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingEvent(JADEEvent ev) {
        HashMap hashMap = this.pendingEvents;
        synchronized (hashMap) {
            AID id = null;
            if (ev instanceof AgentEvent) {
                id = ((AgentEvent)ev).getAgent();
            } else if (ev instanceof MessageEvent) {
                id = ((MessageEvent)ev).getAgent();
            }
            List l = (List)this.pendingEvents.get(id);
            if (l != null) {
                l.remove(ev);
                if (l.isEmpty()) {
                    this.pendingEvents.remove(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPendingEvents(AID id) {
        HashMap hashMap = this.pendingEvents;
        synchronized (hashMap) {
            List l = (List)this.pendingEvents.remove(id);
            if (l != null) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    JADEEvent ev = (JADEEvent)it.next();
                    ev.notifyProcessed(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllPendingEvents() {
        HashMap hashMap = this.pendingEvents;
        synchronized (hashMap) {
            Iterator it1 = this.pendingEvents.values().iterator();
            while (it1.hasNext()) {
                List l = (List)it1.next();
                Iterator it2 = l.iterator();
                while (it2.hasNext()) {
                    JADEEvent ev = (JADEEvent)it2.next();
                    ev.notifyProcessed(null);
                }
            }
        }
    }

    private class SynchEventInformer
    extends SimpleBehaviour {
        private Event ev;
        private JADEEvent jev;
        private boolean finished;
        private MessageTemplate template;

        SynchEventInformer(Agent a, Event ev, JADEEvent jev) {
            super(a);
            this.finished = false;
            this.ev = ev;
            this.jev = jev;
        }

        public void onStart() {
            String replyWith = String.valueOf(this.jev.hashCode());
            ToolNotifier.this.sendEvent(this.ev, replyWith);
            this.template = MessageTemplate.MatchInReplyTo(replyWith);
        }

        public void action() {
            ACLMessage msg = this.myAgent.receive(this.template);
            if (msg != null) {
                this.jev.notifyProcessed(null);
                ToolNotifier.this.removePendingEvent(this.jev);
                this.finished = true;
            } else {
                this.block();
            }
        }

        public boolean done() {
            return this.finished;
        }
    }

    class NotifierAMSListenerBehaviour
    extends ToolAgent.AMSListenerBehaviour {
        NotifierAMSListenerBehaviour() {
        }

        protected void installHandlers(Map handlersTable) {
            handlersTable.put("dead-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    DeadAgent da = (DeadAgent)ev;
                    AID dead = da.getAgent();
                    ToolNotifier.this.removeObservedAgent(dead);
                    if (dead.equals(ToolNotifier.this.observerAgent)) {
                        ToolNotifier.this.suicide();
                    }
                }
            });
            handlersTable.put("moved-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    MovedAgent ma = (MovedAgent)ev;
                    AID moved = ma.getAgent();
                    if (!ToolNotifier.this.here().equals(ma.getTo())) {
                        ToolNotifier.this.removeObservedAgent(moved);
                    }
                }
            });
        }
    }
}

