/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.leap.Properties;
import jade.util.leap.Serializable;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class Logger
extends java.util.logging.Logger
implements Serializable {
    public static final Level SEVERE = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    public static final Level INFO = Level.INFO;
    public static final Level CONFIG = Level.CONFIG;
    public static final Level FINE = Level.FINE;
    public static final Level FINER = Level.FINER;
    public static final Level FINEST = Level.FINEST;
    public static final Level ALL = Level.ALL;
    public static final Level OFF = Level.OFF;
    private static Map wrappers = new HashMap();
    private static PrintStream logStream = System.out;

    private Logger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new DummyLogger(this.getName());
    }

    public static synchronized Logger getJADELogger(String name) {
        LogManager mng = LogManager.getLogManager();
        java.util.logging.Logger lg = mng.getLogger(name);
        if (lg == null) {
            lg = new Logger(name, null);
            mng.addLogger(lg);
            lg = mng.getLogger(name);
        } else if (!(lg instanceof Logger)) {
            lg = Logger.getWrapper(lg);
        }
        return (Logger)lg;
    }

    private static Logger getWrapper(java.util.logging.Logger lg) {
        Logger jadeLogger = (Logger)wrappers.get(lg.getName());
        if (jadeLogger == null) {
            jadeLogger = new LoggerWrapper(lg);
            wrappers.put(lg.getName(), jadeLogger);
        }
        return jadeLogger;
    }

    public static void initialize(Properties pp) {
    }

    public static Logger getMyLogger(String name) {
        return Logger.getJADELogger(name);
    }

    public static void println(String log) {
        logStream.println(log);
    }

    private static class LoggerWrapper
    extends Logger {
        private java.util.logging.Logger realLogger;

        private LoggerWrapper(java.util.logging.Logger lg) {
            super(lg.getName(), null);
            this.realLogger = lg;
        }

        public void log(LogRecord r) {
            this.realLogger.log(r);
        }
    }

    private static class DummyLogger
    implements Serializable {
        private String name;

        public DummyLogger(String n) {
            this.name = n;
        }

        private Object readResolve() throws ObjectStreamException {
            return Logger.getJADELogger(this.name);
        }
    }
}

