/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.core;

import bdi4jade.belief.Belief;
import bdi4jade.core.Capability;
import bdi4jade.core.Intention;
import bdi4jade.event.GoalListener;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.message.BDIAgentMsgReceiver;
import bdi4jade.reasoning.BeliefRevisionStrategy;
import bdi4jade.reasoning.DeliberationFunction;
import bdi4jade.reasoning.OptionGenerationFunction;
import bdi4jade.reasoning.PlanSelectionStrategy;
import bdi4jade.softgoal.Softgoal;
import bdi4jade.util.DefaultCapability;
import bdi4jade.util.reasoning.DefaultBeliefRevisionStrategy;
import bdi4jade.util.reasoning.DefaultDeliberationFunction;
import bdi4jade.util.reasoning.DefaultOptionGenerationFunction;
import bdi4jade.util.reasoning.DefaultPlanSelectionStrategy;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BDIAgent
extends Agent {
    private static final long serialVersionUID = -841774495336214256L;
    private final BDIInterpreter bdiInterpreter;
    private BeliefRevisionStrategy beliefRevisionStrategy;
    private DeliberationFunction deliberationFunction;
    private final List<Intention> intentions;
    private OptionGenerationFunction optionGenerationFunction;
    private PlanSelectionStrategy planSelectionStrategy;
    private final Capability rootCapability = new Capability();
    private final Set<Softgoal> softgoals;

    public BDIAgent() {
        this.intentions = new LinkedList<Intention>();
        this.softgoals = new HashSet<Softgoal>();
        this.bdiInterpreter = new BDIInterpreter(this);
        this.beliefRevisionStrategy = new DefaultBeliefRevisionStrategy();
        this.optionGenerationFunction = new DefaultOptionGenerationFunction();
        this.deliberationFunction = new DefaultDeliberationFunction();
        this.planSelectionStrategy = new DefaultPlanSelectionStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCapability(Capability capability) {
        Capability capability2 = this.rootCapability;
        synchronized (capability2) {
            if (capability.getParent() != null) {
                throw new RuntimeException("Capability already binded to another capability!");
            }
            this.rootCapability.addChild(capability);
            capability.setMyAgent(this);
        }
    }

    public void addGoal(Goal goal) {
        this.addGoal(null, goal, null);
    }

    public void addGoal(Goal goal, GoalListener goalListener) {
        this.addGoal(null, goal, goalListener);
    }

    public void addGoal(Capability owner, Goal goal) {
        this.addGoal(owner, goal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGoal(Capability owner, Goal goal, GoalListener goalListener) {
        List<Intention> list = this.intentions;
        synchronized (list) {
            Intention intention = new Intention(goal, this, owner);
            this.intentions.add(intention);
            this.bdiInterpreter.restart();
            if (goalListener != null) {
                intention.addGoalListener(goalListener);
            }
        }
    }

    public void addSoftgoal(Softgoal softgoal) {
        this.softgoals.add(softgoal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropGoal(Goal goal) {
        List<Intention> list = this.intentions;
        synchronized (list) {
            for (Intention intention : this.intentions) {
                if (!intention.getGoal().equals(goal)) continue;
                intention.noLongerDesire();
                return;
            }
        }
    }

    public void dropSoftoal(Softgoal softgoal) {
        this.softgoals.remove(softgoal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Belief<?>> getAllBeliefs() {
        Capability capability = this.rootCapability;
        synchronized (capability) {
            LinkedList beliefs = new LinkedList();
            this.getAllBeliefs(beliefs, this.rootCapability);
            return beliefs;
        }
    }

    private void getAllBeliefs(Collection<Belief<?>> beliefs, Capability capability) {
        beliefs.addAll(capability.getBeliefBase().getBeliefs());
        for (Capability child : capability.getChildren()) {
            this.getAllBeliefs(beliefs, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Capability> getAllCapabilities() {
        Capability capability = this.rootCapability;
        synchronized (capability) {
            ArrayList<Capability> capabilities = new ArrayList<Capability>();
            this.getAllCapabilities(capabilities, this.rootCapability);
            return capabilities;
        }
    }

    private void getAllCapabilities(List<Capability> capabilities, Capability capability) {
        capabilities.add(capability);
        Set<Capability> children = capability.getChildren();
        for (Capability child : children) {
            this.getAllCapabilities(capabilities, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Goal> getAllGoals() {
        List<Intention> list = this.intentions;
        synchronized (list) {
            HashSet<Goal> goals = new HashSet<Goal>();
            for (Intention intention : this.intentions) {
                goals.add(intention.getGoal());
            }
            return goals;
        }
    }

    public Set<Softgoal> getAllSoftgoals() {
        return this.softgoals;
    }

    public BeliefRevisionStrategy getBeliefRevisionStrategy() {
        return this.beliefRevisionStrategy;
    }

    public DeliberationFunction getDeliberationFunction() {
        return this.deliberationFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Intention> getIntentions() {
        List<Intention> list = this.intentions;
        synchronized (list) {
            HashSet<Intention> activeIntetions = new HashSet<Intention>();
            for (Intention intention : this.intentions) {
                if (GoalStatus.WAITING.equals((Object)intention.getStatus())) continue;
                activeIntetions.add(intention);
            }
            return activeIntetions;
        }
    }

    public OptionGenerationFunction getOptionGenerationFunction() {
        return this.optionGenerationFunction;
    }

    public PlanSelectionStrategy getPlanSelectionStrategy() {
        return this.planSelectionStrategy;
    }

    public Capability getRootCapability() {
        return this.rootCapability;
    }

    protected void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCapability(Capability capability) {
        Capability capability2 = this.rootCapability;
        synchronized (capability2) {
            boolean removed = this.rootCapability.removeChild(capability);
            if (removed) {
                capability.setMyAgent(null);
            }
            return removed;
        }
    }

    public void setBeliefRevisionStrategy(BeliefRevisionStrategy beliefRevisionStrategy) {
        this.beliefRevisionStrategy = beliefRevisionStrategy == null ? new DefaultBeliefRevisionStrategy() : beliefRevisionStrategy;
    }

    public void setDeliberationFunction(DeliberationFunction deliberationFunction) {
        this.deliberationFunction = deliberationFunction == null ? new DefaultDeliberationFunction() : deliberationFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoLongerDesired(Goal goal) {
        List<Intention> list = this.intentions;
        synchronized (list) {
            for (Intention intention : this.intentions) {
                if (!intention.getGoal().equals(goal)) continue;
                intention.noLongerDesire();
                return;
            }
        }
    }

    public void setOptionGenerationFunction(OptionGenerationFunction optionGenerationFunction) {
        this.optionGenerationFunction = optionGenerationFunction == null ? new DefaultOptionGenerationFunction() : optionGenerationFunction;
    }

    public void setPlanSelectionStrategy(PlanSelectionStrategy planSelectionStrategy) {
        this.planSelectionStrategy = planSelectionStrategy == null ? new DefaultPlanSelectionStrategy() : planSelectionStrategy;
    }

    protected final void setup() {
        this.addBehaviour((Behaviour)new BDIAgentMsgReceiver(this, new BDIAgentMsgReceiver.BDIAgentMatchExpression()));
        this.addBehaviour((Behaviour)this.bdiInterpreter);
        this.addCapability(new DefaultCapability());
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void takeDown() {
        Capability capability = this.rootCapability;
        synchronized (capability) {
            Set<Capability> capabilities = this.rootCapability.getChildren();
            for (Capability capability2 : capabilities) {
                this.rootCapability.removeChild(capability2);
            }
        }
    }

    class BDIInterpreter
    extends CyclicBehaviour {
        private static final long serialVersionUID = -6991759791322598475L;
        private Log log;

        public BDIInterpreter(BDIAgent bdiAgent) {
            super((Agent)bdiAgent);
            this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void action() {
            this.log.trace((Object)"Beginning BDI-interpreter cycle.");
            this.log.trace((Object)"Reviewing beliefs.");
            BDIAgent.this.beliefRevisionStrategy.reviewBeliefs(BDIAgent.this);
            List list = BDIAgent.this.intentions;
            synchronized (list) {
                HashMap<Goal, GoalStatus> goalStatus = new HashMap<Goal, GoalStatus>();
                Iterator it = BDIAgent.this.intentions.iterator();
                LinkedList<Intention> doneIntentions = new LinkedList<Intention>();
                while (it.hasNext()) {
                    Intention intention = (Intention)it.next();
                    GoalStatus status = intention.getStatus();
                    switch (status) {
                        case ACHIEVED: 
                        case NO_LONGER_DESIRED: 
                        case UNACHIEVABLE: {
                            doneIntentions.add(intention);
                            it.remove();
                            break;
                        }
                        default: {
                            goalStatus.put(intention.getGoal(), status);
                        }
                    }
                }
                for (Intention intention : doneIntentions) {
                    intention.fireGoalFinishedEvent();
                }
                Set<Goal> generatedGoals = BDIAgent.this.optionGenerationFunction.generateGoals(goalStatus);
                HashSet<Goal> newGoals = new HashSet<Goal>(generatedGoals);
                newGoals.removeAll(goalStatus.keySet());
                for (Goal goal : newGoals) {
                    BDIAgent.this.addGoal(goal);
                }
                HashSet removedGoals = new HashSet(goalStatus.keySet());
                removedGoals.removeAll(generatedGoals);
                for (Goal goal : removedGoals) {
                    it = BDIAgent.this.intentions.iterator();
                    while (it.hasNext()) {
                        Intention intention = (Intention)it.next();
                        if (!intention.getGoal().equals(goal)) continue;
                        intention.noLongerDesire();
                        intention.fireGoalFinishedEvent();
                        it.remove();
                    }
                }
                goalStatus = new HashMap();
                for (Intention intention : BDIAgent.this.intentions) {
                    goalStatus.put(intention.getGoal(), intention.getStatus());
                }
                Set<Goal> selectedGoals = BDIAgent.this.deliberationFunction.filter(goalStatus);
                this.log.trace((Object)("Selected goals to be intentions: " + selectedGoals.size()));
                for (Intention intention : BDIAgent.this.intentions) {
                    if (selectedGoals.contains(intention.getGoal())) {
                        intention.tryToAchive();
                        continue;
                    }
                    intention.doWait();
                }
                if (BDIAgent.this.intentions.isEmpty()) {
                    this.log.trace((Object)"No goals or intentions - blocking cycle.");
                    this.block();
                }
            }
            this.log.trace((Object)"BDI-interpreter cycle finished.");
        }

        public BDIAgent getMyAgent() {
            return (BDIAgent)this.myAgent;
        }
    }
}

