/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.core;

import bdi4jade.core.BDIAgent;
import bdi4jade.core.Capability;
import bdi4jade.event.GoalEvent;
import bdi4jade.event.GoalFinishedEvent;
import bdi4jade.event.GoalListener;
import bdi4jade.exception.PlanInstantiationException;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.plan.Plan;
import bdi4jade.plan.PlanInstance;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Intention {
    private PlanInstance currentPlan;
    private final Set<Plan> executedPlans;
    private final Goal goal;
    private final List<GoalListener> goalListeners;
    private final Log log = LogFactory.getLog(this.getClass());
    private final BDIAgent myAgent;
    private boolean noLongerDesired;
    private final Capability owner;
    private boolean unachievable;
    private boolean waiting;

    public Intention(Goal goal, BDIAgent bdiAgent) {
        this(goal, bdiAgent, null);
    }

    public Intention(Goal goal, BDIAgent bdiAgent, Capability owner) {
        this.goal = goal;
        this.myAgent = bdiAgent;
        this.unachievable = false;
        this.noLongerDesired = false;
        this.waiting = true;
        this.goalListeners = new ArrayList<GoalListener>();
        this.executedPlans = new HashSet<Plan>();
        this.currentPlan = null;
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGoalListener(GoalListener goalListener) {
        List<GoalListener> list = this.goalListeners;
        synchronized (list) {
            this.goalListeners.add(goalListener);
        }
    }

    private synchronized void dispatchPlan() {
        Set<Plan> options = this.getCanAchievePlans();
        options.removeAll(this.executedPlans);
        while (this.currentPlan == null && !options.isEmpty()) {
            Plan selectedPlan = this.myAgent.getPlanSelectionStrategy().selectPlan(this.goal, options);
            try {
                this.currentPlan = new PlanInstance(selectedPlan, this);
            }
            catch (PlanInstantiationException e) {
                this.log.error((Object)("Plan " + selectedPlan.getId() + " could not be instantiated."));
                e.printStackTrace();
                this.currentPlan = null;
                options.remove(selectedPlan);
            }
        }
        if (options.isEmpty()) {
            this.unachievable = true;
        } else {
            this.currentPlan.startPlan();
        }
    }

    public synchronized void doWait() {
        GoalStatus status = this.getStatus();
        switch (status) {
            case WAITING: {
                break;
            }
            case TRYING_TO_ACHIEVE: {
                this.waiting = true;
                this.currentPlan.stopPlan();
                this.currentPlan = null;
                break;
            }
            case PLAN_FAILED: {
                this.waiting = true;
                this.executedPlans.add(this.currentPlan.getPlan());
                this.currentPlan = null;
                break;
            }
            default: {
                assert (false) : status;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGoalEvent(GoalEvent goalEvent) {
        List<GoalListener> list = this.goalListeners;
        synchronized (list) {
            for (GoalListener goalListener : this.goalListeners) {
                goalListener.goalPerformed(goalEvent);
            }
        }
    }

    public void fireGoalFinishedEvent() {
        GoalStatus status = this.getStatus();
        this.log.debug((Object)("Goal: " + this.goal.getClass().getSimpleName() + " (" + (Object)((Object)status) + ") - " + this.goal));
        this.fireGoalEvent(new GoalFinishedEvent(this.goal, status));
    }

    private Set<Plan> getCanAchievePlans() {
        HashSet<Plan> plans = new HashSet<Plan>();
        Capability capability = this.owner == null ? this.myAgent.getRootCapability() : this.owner;
        this.getCanAchievePlans(plans, capability);
        return plans;
    }

    private void getCanAchievePlans(Set<Plan> plans, Capability capability) {
        plans.addAll(capability.getPlanLibrary().canAchievePlans(this.goal));
        for (Capability child : capability.getChildren()) {
            this.getCanAchievePlans(plans, child);
        }
    }

    public Goal getGoal() {
        return this.goal;
    }

    public List<GoalListener> getGoalListeners() {
        return this.goalListeners;
    }

    public BDIAgent getMyAgent() {
        return this.myAgent;
    }

    public synchronized GoalStatus getStatus() {
        if (this.unachievable) {
            return GoalStatus.UNACHIEVABLE;
        }
        if (this.noLongerDesired) {
            return GoalStatus.NO_LONGER_DESIRED;
        }
        if (this.waiting) {
            return GoalStatus.WAITING;
        }
        if (this.currentPlan == null) {
            return GoalStatus.TRYING_TO_ACHIEVE;
        }
        PlanInstance.EndState endState = this.currentPlan.getEndState();
        if (PlanInstance.EndState.FAILED.equals((Object)endState)) {
            return GoalStatus.PLAN_FAILED;
        }
        if (PlanInstance.EndState.SUCCESSFUL.equals((Object)endState)) {
            return GoalStatus.ACHIEVED;
        }
        return GoalStatus.TRYING_TO_ACHIEVE;
    }

    public synchronized void noLongerDesire() {
        GoalStatus status = this.getStatus();
        switch (status) {
            case WAITING: {
                this.noLongerDesired = true;
                break;
            }
            case TRYING_TO_ACHIEVE: {
                this.noLongerDesired = true;
                this.currentPlan.stopPlan();
                this.currentPlan = null;
                break;
            }
            case PLAN_FAILED: {
                this.noLongerDesired = true;
                this.executedPlans.add(this.currentPlan.getPlan());
                this.currentPlan = null;
                break;
            }
            default: {
                assert (false) : status;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGoalListener(GoalListener goalListener) {
        List<GoalListener> list = this.goalListeners;
        synchronized (list) {
            this.goalListeners.remove(goalListener);
        }
    }

    public synchronized void tryToAchive() {
        GoalStatus status = this.getStatus();
        switch (status) {
            case TRYING_TO_ACHIEVE: {
                break;
            }
            case WAITING: {
                this.waiting = false;
                this.dispatchPlan();
                break;
            }
            case PLAN_FAILED: {
                this.executedPlans.add(this.currentPlan.getPlan());
                this.currentPlan = null;
                this.dispatchPlan();
                break;
            }
            default: {
                assert (false) : status;
                break;
            }
        }
    }
}

