/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.util.ClassFinder;
import jade.util.ClassFinderFilter;
import jade.util.ClassFinderListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ClassSelectionDialog
extends JDialog
implements WindowListener,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JButton jButtonOk = null;
    private JButton jButtonCancel = null;
    private JLabel jLabelStatus = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private ClassesTableModel jTableModel;
    private int result;
    private String selectedClassname;
    public static final int DLG_OK = 1;
    public static final int DLG_CANCEL = 0;
    private boolean classesLoaded;
    private String classname;
    private ClassFinderFilter classfilter;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToList(List list) {
        JTable jTable = this.jTable;
        synchronized (jTable) {
            boolean stillSearching;
            boolean bl = stillSearching = list.size() > 0;
            if (stillSearching) {
                this.jTableModel.appendStaticRows(list);
            }
            this.updateLabelStatus(stillSearching);
        }
    }

    private void updateLabelStatus(boolean stillSearching) {
        if (stillSearching) {
            this.jLabelStatus.setText("Searching in classpath for classes that extend " + this.classname + " (" + this.jTableModel.getRowCount() + " found so far)");
        } else {
            this.setCursor(new Cursor(0));
            this.jLabelStatus.setText("Classpath contains " + this.jTableModel.getRowCount() + " classes that extend " + this.classname);
        }
    }

    public String getSelectedClassname() {
        return this.selectedClassname;
    }

    public ClassSelectionDialog(Dialog owner, String title, String classname, ClassFinderFilter classfilter) {
        super(owner, title, true);
        this.initialize();
        this.classesLoaded = false;
        this.classname = classname;
        this.classfilter = classfilter;
    }

    public ClassSelectionDialog(Dialog owner, String title, String classname) {
        this(owner, title, classname, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doShow(Collection firstRows) {
        this.jButtonOk.setEnabled(false);
        JTable jTable = this.jTable;
        synchronized (jTable) {
            this.jTableModel.setDynamicRows(firstRows);
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.result;
    }

    public int doShow() {
        return this.doShow(new Vector(0));
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabelStatus = new JLabel();
            this.jLabelStatus.setPreferredSize(new Dimension(0, 15));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "South");
            this.jContentPane.add((Component)this.jLabelStatus, "North");
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            gridLayout.setColumns(2);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(gridLayout);
            this.jPanel.setPreferredSize(new Dimension(20, 20));
            this.jPanel.add((Component)this.getJButtonOk(), null);
            this.jPanel.add((Component)this.getJButtonCancel(), null);
        }
        return this.jPanel;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("Ok");
            this.jButtonOk.addActionListener(this);
        }
        return this.jButtonOk;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(this);
        }
        return this.jButtonCancel;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
        if (!this.classesLoaded) {
            this.setCursor(new Cursor(3));
            this.updateLabelStatus(true);
            ClassUpdater cu = new ClassUpdater(this.classname, this.classfilter == null ? new ClassFilter() : this.classfilter);
            new Thread(cu).start();
        }
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setAutoCreateColumnsFromModel(true);
            this.jTable.setDoubleBuffered(true);
            this.jTable.setAutoResizeMode(3);
            this.jTable.setModel(this.getClassesTableModel());
            this.jTable.setVisible(true);
            this.jTable.getSelectionModel().addListSelectionListener(this);
            this.jTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ClassSelectionDialog.this.jButtonOk.doClick();
                    }
                }
            });
        }
        return this.jTable;
    }

    private ClassesTableModel getClassesTableModel() {
        if (this.jTableModel == null) {
            this.jTableModel = new ClassesTableModel();
        }
        return this.jTableModel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButtonOk) {
            this.result = 1;
            int index = this.jTable.getSelectedRow();
            if (index >= 0) {
                this.selectedClassname = this.jTableModel.getRowValue(index);
            }
        } else {
            this.result = 0;
        }
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.jButtonOk.setEnabled(true);
        }
    }

    public static class ClassesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private Vector dynamicRowData = new Vector();
        private Vector staticRowData = new Vector();

        public String getColumnName(int col) {
            return "Classname";
        }

        public int getRowCount() {
            return this.dynamicRowData.size() + this.staticRowData.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueAt(int row, int col) {
            return this.getRowValue(row);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void appendStaticRows(Collection newRows) {
            if (newRows.size() > 0) {
                int firstRow = this.staticRowData.size();
                this.staticRowData.addAll(newRows);
                this.fireTableRowsInserted(firstRow, this.staticRowData.size() - 1);
            }
        }

        public void setDynamicRows(Collection rows) {
            this.dynamicRowData.clear();
            this.fireTableRowsDeleted(0, this.dynamicRowData.size());
            if (rows.size() > 0) {
                this.dynamicRowData.addAll(rows);
                this.fireTableRowsInserted(0, this.dynamicRowData.size() - 1);
            }
        }

        public String getRowValue(int index) {
            if (index < this.dynamicRowData.size()) {
                return (String)this.dynamicRowData.get(index);
            }
            return (String)this.staticRowData.get(index - this.dynamicRowData.size());
        }
    }

    private class ClassUpdater
    implements Runnable,
    ClassFinderListener {
        private static final int UPDATE_EVERY = 1;
        private int numberOfClasses;
        private List classNamesCache;
        private String classname;
        private ClassFinderFilter classfilter;

        public ClassUpdater(String classname, ClassFinderFilter classfilter) {
            this.classname = classname;
            this.classfilter = classfilter;
        }

        public void add(Class clazz, URL location) {
            ++this.numberOfClasses;
            this.classNamesCache.add(clazz.getName());
            if (this.numberOfClasses % 1 == 0) {
                ClassSelectionDialog.this.appendToList(this.classNamesCache);
                this.classNamesCache.clear();
            }
        }

        public void run() {
            this.classNamesCache = new ArrayList(1);
            this.numberOfClasses = 0;
            ClassFinder cf = new ClassFinder();
            cf.findSubclasses(this.classname, this, this.classfilter);
            if (this.classNamesCache.size() > 0) {
                ClassSelectionDialog.this.appendToList(this.classNamesCache);
                this.classNamesCache.clear();
            }
            ClassSelectionDialog.this.appendToList(this.classNamesCache);
            this.classNamesCache = null;
            ClassSelectionDialog.this.classesLoaded = true;
        }
    }

    private class ClassFilter
    implements ClassFinderFilter {
        private ClassFilter() {
        }

        public boolean include(Class superClazz, Class clazz) {
            boolean doInclude;
            int modifiers = clazz.getModifiers();
            boolean bl = doInclude = (modifiers & 0x600) == 0;
            if (doInclude) {
                doInclude = !clazz.getName().equals(ClassSelectionDialog.this.classname);
            }
            return doInclude;
        }
    }
}

